<?php
// Conexión
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión");
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Resultado de abono</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f9f9f9;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    .mensaje {
      background-color: #ffffff;
      border: 1px solid #ccc;
      padding: 30px 40px;
      border-radius: 10px;
      text-align: center;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .mensaje h2 {
      color: #003566;
      margin-bottom: 20px;
    }
    .mensaje p {
      margin-bottom: 30px;
      color: #333;
    }
    .btn-volver {
      background-color: #003566;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 6px;
      text-decoration: none;
      font-weight: bold;
    }
    .btn-volver:hover {
      background-color: #00509d;
    }
  </style>
</head>
<body>

<div class="mensaje">
<?php
// DATOS DESDE POST
$num = $_POST["num_prestamo"] ?? null;
$importe = $_POST["importe"] ?? null;

if (!$num || !$importe) {
    die("Datos incompletos");
}

$num = intval($num);
$importe = floatval($importe);

if ($importe <= 0) {
    die("Monto inválido");
}

// CONSULTAR PRÉSTAMO Y ABONOS
$sql = "
SELECT 
    P.importe,
    IFNULL(SUM(A.importe_pagado),0) AS total_abonado
FROM prestamo P
LEFT JOIN abono A ON P.num_prestamo = A.num_prestamo
WHERE P.num_prestamo = ?
GROUP BY P.importe
";

$stmt = $conexion->prepare($sql);
$stmt->bind_param("i", $num);
$stmt->execute();
$result = $stmt->get_result();

if (!$row = $result->fetch_assoc()) {
    die("Préstamo no encontrado");
}

$total = $row["importe"];
$abonado = $row["total_abonado"];
$restante = $total - $abonado;

if ($importe > $restante) {
    die("El abono excede el saldo restante");
}

// INSERTAR ABONO
$insert = $conexion->prepare("
    INSERT INTO abono (num_prestamo, importe_pagado)
    VALUES (?, ?)
");
$insert->bind_param("id", $num, $importe);
$insert->execute();

// ¿SE FINALIZA?
if (($abonado + $importe) >= $total) {
    $upd = $conexion->prepare("
        UPDATE prestamo 
        SET estado = 'finalizado'
        WHERE num_prestamo = ?
    ");
    $upd->bind_param("i", $num);
    $upd->execute();
}

header("Location: prestamos.php?msg=abono_ok");
exit;
?>
</div>
</body>
</html>
