<!-- Alberto Davis, 8-1019-1563, María Ferrer 20-70-7664, Miguel Rodríguez 8-1016-2196, Yessica Cuevas 8-1002-794, Víctor Lee 4-826-239 -->

<?php
session_start();

// Conexión a la BD
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Agregar Cliente</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            text-align: center;
            padding: 60px;
            background-color: #f2f2f2;
        }

        .mensaje {
            display: inline-block;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.1);
        }

        .mensaje h2 {
            color: #003566;
        }

        .mensaje p {
            font-size: 1.1rem;
            margin-top: 10px;
            color: #333;
        }

        .btn-volver {
            margin-top: 25px;
            background-color: #0077b6;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 6px;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
        }

        .btn-volver:hover {
            background-color: #003566;
        }
    </style>
</head>
<body>

<div class="mensaje">
<?php

$cedula = $_POST["cedula"] ?? null;
$nombre = $_POST["nombre"] ?? null;
$ciudad = $_POST["ciudad"] ?? null;
$ubicacion = $_POST["ubicacion"] ?? null;
$correo = $_POST["correo"] ?? null;
$clave = $_POST["clave"] ?? null;

// Validación básica
if ($cedula && $nombre && $correo && $clave && strlen($clave) >= 4) {

    // Verificar si el correo ya existe
    $sqlCheck = $conexion->prepare("SELECT 1 FROM Cliente WHERE correo_electronico = ?");
    $sqlCheck->bind_param("s", $correo);
    $sqlCheck->execute();
    $resultado = $sqlCheck->get_result();

    if ($resultado->num_rows > 0) {
        echo "
        <h2>Correo ya registrado</h2>
        <p>El correo electrónico <strong>' .htmlspecialchars($correo, ENT_QUOTES, 'UTF-8') .'</strong> ya está en uso.</p>';
        <a href='clientes.php' class='btn-volver'>Volver</a>
        ";
    } else {

        // Insertar cliente
        $sql = $conexion->prepare("
            INSERT INTO Cliente (cedula_cliente, nombre, ciudad, ubicacion, correo_electronico, clave_hash)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $sql->bind_param("ssssss", $cedula, $nombre, $ciudad, $ubicacion, $correo, $clave);

        if ($sql->execute()) {
            $_SESSION["cedula_registrada"] = $cedula;
            header("Location: clientes.php");
            exit();
        } else {
            echo "
            <h2> No se pudo agregar el cliente</h2>
            <p>Ocurrió un error inesperado al registrar el cliente.</p>
            <a href='clientes.php' class='btn-volver'>Volver</a>
            ";
        }
    }

} else {
    echo "
    <h2> Datos inválidos</h2>
    <p>Completa todos los campos y asegúrate de que la contraseña tenga al menos 4 caracteres.</p>
    <a href='clientes.php' class='btn-volver'>Volver</a>
    ";
}

$conexion->close();
?>

    <a href="clientes.php" class="btn-volver">← Volver a Clientes</a>
</div>

</body>
</html>



