
<?php
session_start();

// Conexión a la BD
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Agregar Teléfono</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            text-align: center;
            padding: 60px;
            background-color: #f2f2f2;
        }

        .mensaje {
            display: inline-block;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.1);
        }

        .mensaje h2 {
            color: #003566;
        }

        .mensaje p {
            font-size: 1.1rem;
            margin-top: 10px;
            color: #333;
        }

        .btn-volver {
            margin-top: 25px;
            background-color: #0077b6;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 6px;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
        }

        .btn-volver:hover {
            background-color: #003566;
        }
    </style>
</head>
<body>

<div class="mensaje">
<?php

$cedula = $_POST["cedula"] ?? null;
$telefono = $_POST["telefono"] ?? null;

// Validación básica
if ($cedula && $telefono) {

    // Validar que el cliente exista
$sqlExiste = $conexion->prepare("SELECT 1 FROM cliente WHERE cedula_cliente = ?");
    $sqlExiste->bind_param("s", $cedula);
    $sqlExiste->execute();
    $existe = $sqlExiste->get_result();

    if ($existe->num_rows === 0) {
        echo "
        <h2>Cliente no encontrado</h2>
        <p>No existe un cliente con la cédula
       <strong><?= htmlspecialchars($cedula, ENT_QUOTES, 'UTF-8') ?></strong>.
        </p>
        ";
    } else {

        // Insertar teléfono
        $sql = $conexion->prepare("
            INSERT INTO telefonocliente (cedula_cliente, telefono)
            VALUES (?, ?)
        ");
        $sql->bind_param("ss", $cedula, $telefono);

        if ($sql->execute()) {
            echo "
            <h2> Teléfono agregado</h2>
            <p>Se agregó el número <strong>$telefono</strong> al cliente <strong>$cedula</strong>.</p>
            <a href='telefonos.php' class='btn-volver'>Volver a Teléfonos</a>
            ";
        } else {
            echo "
            <h2>❌ Error al agregar</h2>
            <p>No se pudo registrar el teléfono.</p>
            <a href='telefonos.php' class='btn-volver'>Volver</a>
            ";
        }
    }

} else {
    echo "
    <h2>❌ Datos incompletos</h2>
    <p>Debes ingresar una cédula y un número de teléfono.</p>
    <a href='telefonos.php' class='btn-volver'>Volver</a>
    ";
}

$conexion->close();
?>

</div>

</body>
</html>

