<?php
session_start();

// Nombre del administrador
$adminNombre = "Administrador";

// Conexión a BD
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

// Leer mensaje opcional
$mensaje = $_GET["msg"] ?? null;
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Asesorías - Administración</title>
  <link rel="stylesheet" href="css/barra.css">
  <style>
    /* --- MISMO CSS DEL JSP --- */
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #ffffff;
    }
    .menu {
      background-color: #003566;
      color: white;
      padding: 15px 40px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    .menu .logo img { height: 50px; }
    .menu nav a {
      color: white;
      text-decoration: none;
      margin: 0 30px;
      font-weight: bold;
      transition: color 0.3s ease;
    }
    .menu nav a:hover { color: #00b4d8; }
    .perfil-container {
      display: flex;
      align-items: center;
      cursor: pointer;
      position: relative;
    }
    .perfil-container img {
      height: 40px; width: 40px; border-radius: 50%;
    }
    .dropdown {
      display: none;
      position: absolute;
      top: 60px;
      right: 0;
      background: white;
      border-radius: 6px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }
    .dropdown a {
      display: block;
      padding: 10px 20px;
      text-decoration: none;
      color: #003566;
      font-weight: bold;
    }
    .volver-panel { margin: 30px 40px 0; }
    .volver-panel a {
      color: #6c757d;
      font-weight: bold;
      text-decoration: none;
    }
    .volver-panel a:hover { color: #0077b6; }
    .contenido { padding: 40px; }
    .contenido h1 {
      color: #003566;
      font-size: 2rem;
    }
    .acciones-superior {
      display: flex;
      justify-content: space-between;
      margin: 20px 0;
    }
    .acciones-superior input {
      padding: 10px;
      width: 300px;
      border-radius: 6px;
      border: 1px solid #ccc;
    }
    .acciones-superior button {
      background: linear-gradient(135deg, #0077b6, #00b4d8);
      color: white;
      padding: 10px 18px;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      cursor: pointer;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    th, td {
      padding: 12px;
      border-bottom: 1px solid #ccc;
    }
    th {
      background-color: #f0f0f0;
      color: #003566;
    }
    .editar-btn {
      padding: 6px 12px;
      background-color: #0077b6;
      color: white;
      border: none;
      border-radius: 5px;
      font-weight: bold;
      cursor: pointer;
    }
    .modal {
      display: none;
      position: fixed;
      z-index: 100;
      left: 0; top: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.5);
      justify-content: center; align-items: center;
    }
    .modal-content {
      background: white;
      padding: 30px;
      border-radius: 10px;
      width: 400px;
      position: relative;
    }
    .cerrar {
      position: absolute;
      top: 10px;
      right: 15px;
      cursor: pointer;
    }
  </style>
</head>
<body>

<!-- MENU -->
<div class="menu">
  <div class="logo"><img src="img/logo.png" alt="Logo"></div>
  <nav>
    <a href="prestamos.php">Préstamos</a>
    <a href="clientes.php">Clientes</a>
    <a href="asesorias.php">Asesorías</a>
    <a href="cuentas.php">Cuentas</a>
  </nav>

  <div class="perfil-container" onclick="toggleDropdown()">
    <img src="img/logoadmin.png">
    <span><?= $adminNombre ?></span>
    <div class="dropdown" id="dropdownMenu">
      <a href="loginadmin.html">Cerrar sesión</a>
    </div>
  </div>
</div>

<div class="volver-panel">
  <a href="paneladmin.php">← Volver al Panel</a>
</div>

<div class="contenido">

  <h1>Asesorías</h1>

  <div class="acciones-superior">
    <input type="text" id="busqueda-nombre" onkeyup="filtrarAsesorias()" placeholder="Buscar asesoría por nombre">
    <button onclick="abrirModal()">+ Añadir asesoría</button>
  </div>

  <!-- MENSAJES -->
  <?php if ($mensaje === "ok"): ?>
    <p style="color:green;text-align:center;">Asesoría registrada correctamente.</p>
  <?php elseif ($mensaje === "finalizada"): ?>
    <p style="color:green;text-align:center;">Asesoría completada.</p>
  <?php elseif ($mensaje === "error"): ?>
    <p style="color:red;text-align:center;">Error en la asesoría. Verifica los datos.</p>
  <?php endif; ?>

  <!-- TABLA -->
    <table>
    <thead>
    <tr>
        <th>Cédula Cliente</th>
        <th>Tipo</th>
        <th>Descripción</th>
        <th>Fecha</th>
        <th>Estado</th>
        <th>Acciones</th>
    </tr>
    </thead>

    <tbody id="tabla-asesorias">
    <?php
      $sql = "
      SELECT 
          id_asesoria,
          cedula_cliente,
          tipo_asesoria,
          descripcion,
          fecha_asesoria,
          estado
      FROM asesoria
      ORDER BY fecha_asesoria DESC
      ";

      $resultado = $conexion->query($sql);

      if ($resultado && $resultado->num_rows > 0):
          while ($fila = $resultado->fetch_assoc()):
    ?>
      <tr>
    <td><?= $fila['cedula_cliente'] ?></td>
        <td><?= $fila['tipo_asesoria'] ?></td>
        <td><?= $fila['descripcion'] ?></td>
        <td><?= $fila['fecha_asesoria'] ?></td>
        <td><?= $fila["estado"] ?></td>
        <td>
          <?php if ($fila["estado"] !== "completada"): ?>
            <form action="completar_asesoria.php" method="post">
              <input type="hidden" name="id_asesoria" value="<?= $fila["id_asesoria"] ?>">
              <button class="editar-btn">Completar</button>
            </form>
          <?php else: ?>
            <span style="color:gray;">—</span>
          <?php endif; ?>
        </td>
      </tr>
    <?php
          endwhile;
      else:
    ?>
      <tr><td colspan="4" style="text-align:center;color:gray;">No hay asesorías registradas.</td></tr>
    <?php endif; ?>
    </tbody>
  </table>
</div>

<!-- MODAL -->
<div class="modal" id="modalCliente">
  <div class="modal-content">
    <span class="cerrar" onclick="cerrarModal()">×</span>
    <h2>Registrar Asesoría</h2>

<form action="insertar_asesoria.php" method="post">

  <input type="text" name="cedula_cliente" placeholder="Cédula del cliente" required>

  <input type="text" name="cedula_empleado" placeholder="Cédula del asesor" required>

  <select name="tipo_asesoria" required>
    <option value="">Tipo de asesoría</option>
    <option value="inversion">Inversión</option>
    <option value="hipotecario">Hipotecario</option>
    <option value="financiero">Financiero</option>
    <option value="otros">Otros</option>
  </select>

  <input type="date" name="fecha_asesoria" required>

  <button type="submit">Guardar Asesoría</button>
</form>


  </div>
</div>

<script>
function toggleDropdown() {
  const d = document.getElementById("dropdownMenu");
  d.style.display = d.style.display === "block" ? "none" : "block";
}

function abrirModal() {
  document.getElementById("modalCliente").style.display = "flex";
}

function cerrarModal() {
  document.getElementById("modalCliente").style.display = "none";
}

function filtrarAsesorias() {
  const input = document.getElementById("busqueda-nombre").value.toLowerCase();
  const filas = document.querySelectorAll("#tabla-asesorias tr");

  filas.forEach(fila => {
    const nombre = fila.children[0].innerText.toLowerCase();
    fila.style.display = nombre.includes(input) ? "" : "none";
  });
}

window.onclick = (e) => {
  const dropdown = document.getElementById("dropdownMenu");
  if (!e.target.closest(".perfil-container")) dropdown.style.display = "none";
};
</script>

</body>
</html>
