<?php
session_start();

// Obtener cédula por GET/POST
$cedula = $_GET["cedula"] ?? $_POST["cedula"] ?? null;

if (!$cedula) {
    header("Location: HOME.html");
    exit();
}

// Conexión a la BD
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

// Consultar datos del cliente
$sql = $conexion->prepare("
    SELECT nombre, ciudad, ubicacion, correo_electronico 
    FROM cliente 
    WHERE cedula_cliente = ?
");
$sql->bind_param("s", $cedula);
$sql->execute();
$resultado = $sql->get_result();

if ($resultado->num_rows === 0) {
    header("Location: HOME.html");
    exit();
}

$cliente = $resultado->fetch_assoc();
$nombre = $cliente["nombre"];
$ciudad = $cliente["ciudad"];
$ubicacion = $cliente["ubicacion"];
$correo = $cliente["correo_electronico"];
?>


<?php if (isset($_GET['ok_datos'])): ?>
<div class="mensaje mensaje-ok">
  <span>✅ Datos personales actualizados correctamente</span>
  <a href="cliente_panel.php?cedula=<?= urlencode(htmlspecialchars($cedula, ENT_QUOTES, 'UTF-8')) ?>"
   class="cerrar">×</a>
</div>
<?php endif; ?>


<?php if (isset($_GET['ok_prestamo'])): ?>
<div style="background:#d4edda;color:#155724;padding:12px;border-radius:6px;">
  ✅ Solicitud de préstamo enviada correctamente
</div>
<?php endif; ?>

<?php if (isset($_GET['ok_asesoria'])): ?>
<div style="background:#d4edda;color:#155724;padding:12px;border-radius:6px;">
  ✅ Asesoría solicitada correctamente
</div>
<?php endif; ?>

<?php if (isset($_GET['error'])): ?>
<div style="background:#f8d7da;color:#721c24;padding:12px;border-radius:6px;">
  ❌ Ocurrió un error al procesar la solicitud
</div>
<?php endif; ?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel del Cliente</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #f0f2f5;
        }

        header {
            background-color: #003566;
            color: white;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        header h1 {
            margin: 0;
            font-size: 24px;
        }

        .buttons {
            display: flex;
            gap: 10px;
        }

        .buttons a {
            background-color: #ffffff;
            color: #003566;
            padding: 8px 16px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: bold;
            transition: background 0.3s;
        }

        .buttons a:hover {
            background-color: #e0e0e0;
        }

        .panel-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            grid-template-rows: 1fr 1fr;
            gap: 20px;
            width: 100%;
            height: calc(100vh - 80px);
            padding: 20px;
            box-sizing: border-box;
        }

        .card {
            background-color: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 30px;
            overflow-y: auto;
            background: linear-gradient(to bottom right, #f5f9ff, #ffffff);
            animation: fadeInUp 0.8s ease-in-out;
        }

        .card h2 {
            font-size: 22px;
            margin-bottom: 25px;
            color: #003566;
        }

        .info-line {
            display: flex;
            justify-content: space-between;
            padding: 12px 20px;
            margin-bottom: 12px;
            border: 1px solid #d0d7e2;
            border-radius: 8px;
            background-color: #f9fbff;
            font-size: 17px;
            font-weight: bold;
            color: #1b1b1b;
            opacity: 0;
            animation: appear 0.5s ease forwards;
        }

        .info-line span:first-child {
            color: #003566;
            width: 40%;
        }

        .info-line span:last-child {
            width: 58%;
        }

        .table-style {
            width: 100%;
            border-collapse: collapse;
            font-size: 16px;
        }

        .table-style th, .table-style td {
            padding: 12px 15px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }

        .table-style th {
            background-color: #f0f0f0;
            color: #003566;
            font-weight: bold;
        }

        .table-style tr:hover {
            background-color: #f9f9f9;
        }

        @keyframes appear {
            to { opacity: 1; transform: translateY(0); }
            from { opacity: 0; transform: translateY(10px); }
        }

        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .mensaje {
        padding: 12px 16px;
        border-radius: 6px;
        margin-bottom: 15px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 15px;
        }

        .mensaje-ok {
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
        }

        .mensaje-error {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
        }

        .cerrar {
        text-decoration: none;
        color: inherit;
        font-weight: bold;
        font-size: 16px;
        }

        .cerrar:hover {
        opacity: 0.7;
        }

    </style>
</head>
<body>

<header>
    <h1>Panel del Cliente</h1>
    <div class="buttons">
        <a href="HOME.html">Volver a inicio</a>
        <a href="logincliente.html">Cerrar sesión</a>
    </div>
</header>

<div class="panel-container">

    <!-- Datos del Cliente -->
    <div class="card">
        <h2>Mis Datos Personales</h2>

        <form action="actualizar_datos_cliente.php" method="post">
            <input type="hidden" name="cedula"
       value="<?= htmlspecialchars($cedula, ENT_QUOTES, 'UTF-8') ?>">

            <label>Nombre</label>
            <input type="text" name="nombre" value="<?= $nombre ?>" required><br>

            <label>Ciudad</label>
            <input type="text" name="ciudad" value="<?= $ciudad ?>"><br>

            <label>Ubicación</label>
            <input type="text" name="ubicacion" value="<?= $ubicacion ?>"><br>

            <label>Correo electrónico</label>
            <input type="email" name="correo" value="<?= $correo ?>" required><br>

            <button type="submit">Guardar cambios</button>
        </form>
    </div>



    <!-- Préstamos -->
    <div class="card">
        <h2>Préstamos</h2>
        <form action="solicitar_prestamo.php" method="post">
            <input type="number" name="importe" placeholder="Monto solicitado" required>
            <input type="number" name="meses" placeholder="Cantidad de meses" required>
            <button type="submit">Solicitar Préstamo</button>
        </form>


        <?php
        $prest = $conexion->prepare("
            SELECT num_prestamo, importe, tasa_interes, cantidad_meses, estado 
            FROM prestamo 
            WHERE cedula_cliente = ?
        ");
        $prest->bind_param("s", $cedula);
        $prest->execute();
        $resPrest = $prest->get_result();

        if ($resPrest->num_rows === 0) {
            echo "<p>No tiene préstamos registrados.</p>";
        } else {
            echo "<table class='table-style'>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Importe</th>
                            <th>Tasa (%)</th>
                            <th>Meses</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>";
            while ($row = $resPrest->fetch_assoc()) {
                echo "<tr>
                        <td>{$row['num_prestamo']}</td>
                        <td>\${$row['importe']}</td>
                        <td>{$row['tasa_interes']}</td>
                        <td>{$row['cantidad_meses']}</td>
                        <td>{$row['estado']}</td>
                      </tr>";
            }
            echo "</tbody></table>";
        }
        ?>
    </div>

    <!-- Cuentas -->
    <div class="card">
        <h2>Cuentas</h2>
        <form action="solicitar_cuenta.php" method="post">
        <input type="hidden" name="cedula"
       value="<?= htmlspecialchars($cedula, ENT_QUOTES, 'UTF-8') ?>">
    <select name="tipo_cuenta" required>
        <option value="">Tipo de cuenta</option>
        <option value="ahorro">Ahorro</option>
        <option value="corriente">Corriente</option>
    </select>
    <button type="submit">Solicitar Cuenta</button>
</form>

        <?php
$cuentas = $conexion->prepare("
    SELECT 
        c.num_cuenta,
        c.saldo,
        c.tipo_cuenta,
        c.fecha_apertura
    FROM Cuenta c
    INNER JOIN Cliente_Cuenta cc ON c.num_cuenta = cc.num_cuenta
    WHERE cc.cedula_cliente = ?
");

        $cuentas->bind_param("s", $cedula);
        $cuentas->execute();
        $resCuentas = $cuentas->get_result();

        if ($resCuentas->num_rows === 0) {
            echo "<p>No tiene cuentas asociadas.</p>";
        } else {
            echo "<table class='table-style'>
                    <thead>
                    <tr>
                        <th>Número</th>
                        <th>Tipo</th>
                        <th>Saldo</th>
                        <th>Fecha Apertura</th>
                    </tr>
                    </thead>
                    <tbody>";

        while ($row = $resCuentas->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['num_cuenta']}</td>
                    <td>{$row['tipo_cuenta']}</td>
                    <td>$" . number_format($row['saldo'], 2) . "</td>
                    <td>{$row['fecha_apertura']}</td>
                </tr>";
        }

            echo "</tbody></table>";
        }
        ?>
    </div>

    <!-- Asesorías -->
    <div class="card">
        <h2>Asesorías</h2>
        <form action="solicitar_asesoria.php" method="post">
    <input type="hidden" name="cedula" value="<?= $cedula ?>">
    <label>Motivo de la asesoría:</label><br>
    <textarea name="descripcion" required rows="4" cols="40"></textarea><br>
    <select name="tipo_asesoria" required>
        <option value="">Tipo de asesoría</option>
        <option value="financiero">Financiero</option>
        <option value="hipotecario">Hipotecario</option>
        <option value="inversion">Inversión</option>
        <option value="otros">Otros</option>
    </select>
    <button type="submit">Solicitar Asesoría</button>
</form>

<?php if (isset($_GET['ok_asesoria'])): ?>
    <div style="
        background:#e6f4ea;
        border:1px solid #2e7d32;
        color:#2e7d32;
        padding:15px;
        margin-bottom:20px;
        border-radius:6px;
        font-weight:bold;
    ">
        ✅ Tu solicitud de asesoría fue enviada correctamente y
        <strong>está pendiente de aprobación</strong>.
    </div>
<?php endif; ?>


<?php if (isset($_GET['error_asesoria']) && $_GET['error_asesoria'] == 'pendiente'): ?>
<div class="msg-error">⚠️ Debe esperar respuesta a su asesoría pendiente</div>
<?php endif; ?>

<?php if (isset($_GET['error_asesoria']) && $_GET['error_asesoria'] == 'campos'): ?>
<div class="msg-error">❌ El motivo no puede estar vacío</div>
<?php endif; ?>

        <?php
        $ases = $conexion->prepare("
            SELECT id_asesoria, fecha_asesoria, estado, tipo_asesoria 
            FROM asesoria 
            WHERE cedula_cliente = ?
        ");
        $ases->bind_param("s", $cedula);
        $ases->execute();
        $resAses = $ases->get_result();

        if ($resAses->num_rows === 0) {
            echo "<p>No tiene asesorías programadas.</p>";
        } else {
            echo "<table class='table-style'>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Fecha</th>
                            <th>Estado</th>
                            <th>Tipo</th>
                        </tr>
                    </thead>
                    <tbody>";
            while ($row = $resAses->fetch_assoc()) {
                echo "<tr>
                        <td>{$row['id_asesoria']}</td>
                        <td>{$row['fecha_asesoria']}</td>
                        <td>{$row['estado']}</td>
                        <td>{$row['tipo_asesoria']}</td>
                      </tr>";
            }
            echo "</tbody></table>";
        }
        ?>
    </div>

</div>

</body>
</html>

<?php
$conexion->close();

?>


