<?php
session_start();

// Datos del administrador (equivalente a adminNombre en JSP)
$adminNombre = "Administrador";

// Conexión a BD
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

// Verificar si viene la cédula para abrir el modal de teléfonos
$cedulaTelefono = $_SESSION["cedula_registrada"] ?? null;
if ($cedulaTelefono) {
    unset($_SESSION["cedula_registrada"]);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" href="css/barra.css">
  <title>Clientes - Administración</title>

  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #ffffff;
    }

    .menu {
      background-color: #003566;
      color: white;
      padding: 15px 40px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .menu .logo img { height: 50px; }

    .menu nav a {
      color: white;
      text-decoration: none;
      margin: 0 30px;
      font-weight: bold;
    }

    .menu nav a:hover { color: #00b4d8; }

    .perfil-container {
      display: flex;
      align-items: center;
      gap: 10px;
      position: relative;
      cursor: pointer;
    }

    .perfil-container img {
      height: 40px;
      width: 40px;
      border-radius: 50%;
    }

    .dropdown {
      display: none;
      position: absolute;
      top: 60px;
      right: 0;
      background-color: white;
      border-radius: 6px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.2);
      z-index: 1000;
    }

    .dropdown a {
      display: block;
      padding: 10px 20px;
      color: #003566;
      text-decoration: none;
      font-weight: bold;
    }

    .dropdown a:hover { background-color: #0077b6; color: white; }

    .contenido {
      padding: 40px;
    }

    .contenido h1 {
      color: #003566;
      font-size: 2rem;
    }

    .acciones-superior {
      display: flex;
      justify-content: space-between;
      margin: 20px 0;
    }

    .acciones-superior input {
      padding: 10px;
      width: 300px;
      border-radius: 6px;
      border: 1px solid #ccc;
    }

    .acciones-superior button {
      background: linear-gradient(135deg, #0077b6, #00b4d8);
      color: white;
      padding: 10px 18px;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      cursor: pointer;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    th, td {
      padding: 12px;
      text-align: left;
      border-bottom: 1px solid #ccc;
    }

    th {
      background-color: #f0f0f0;
      color: #003566;
    }

    /* Modal */
    .modal {
      display: none;
      position: fixed;
      z-index: 100;
      left: 0; top: 0;
      width: 100%; height: 100%;
      background-color: rgba(0, 0, 0, 0.5);
      justify-content: center;
      align-items: center;
    }

    .modal-content {
      background-color: white;
      padding: 30px;
      border-radius: 10px;
      width: 400px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
      position: relative;
    }

    .modal-content h2 { margin-top: 0; color: #003566; }

    .modal-content input {
      width: 100%;
      margin-top: 10px;
      padding: 10px;
      border-radius: 6px;
      border: 1px solid #ccc;
    }

    .modal-content button {
      background-color: #003566;
      color: white;
      font-weight: bold;
      margin-top: 20px;
      padding: 12px;
      width: 100%;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }

    .cerrar {
      position: absolute;
      top: 10px;
      right: 15px;
      font-size: 20px;
      cursor: pointer;
    }
  </style>

<?php if ($cedulaTelefono): ?>
<script>
    window.addEventListener("DOMContentLoaded", function () {
        abrirModalTelefonos("<?php echo $cedulaTelefono; ?>");
    });
</script>
<?php endif; ?>

</head>

<body>

<div class="menu">
  <div class="logo"><img src="img/logo.png" alt="Logo del banco"></div>
  <nav>
    <a href="prestamos.php">Préstamos</a>
    <a href="#">Clientes</a>
    <a href="asesorias.php">Asesorías</a>
    <a href="cuentas.php">Cuentas</a>
  </nav>

  <div class="perfil-container" onclick="toggleDropdown()">
    <img src="img/logoadmin.png" alt="Perfil">
    <span><?= $adminNombre ?></span>

    <div class="dropdown" id="dropdownMenu">
      <a href="loginadmin.html">Cerrar sesión</a>
    </div>
  </div>
</div>

<div class="contenido">
  <h1>Clientes</h1>

  <div class="acciones-superior">
    <input type="text" id="buscar" placeholder="Buscar por cédula o nombre..." onkeyup="filtrarClientes()">
    <button onclick="abrirModal()">+ Añadir cliente</button>
  </div>

  <table>
    <thead>
      <tr>
        <th>Cédula</th>
        <th>Nombre</th>
        <th>Ciudad</th>
        <th>Correo</th>
      </tr>
    </thead>

    <tbody id="tabla-clientes">
      <?php
      $consulta = $conexion->query("SELECT * FROM Cliente");

      if ($consulta && $consulta->num_rows > 0):
          while ($fila = $consulta->fetch_assoc()):
      ?>
      <tr>
        <td><?= $fila["cedula_cliente"] ?></td>
        <td><?= $fila["nombre"] ?></td>
        <td><?= $fila["ciudad"] ?></td>
        <td><?= $fila["correo_electronico"] ?></td>
      </tr>
      <?php
          endwhile;
      else:
      ?>
      <tr><td colspan="4" style="color:red;">No se encontraron clientes.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<!-- MODAL AÑADIR CLIENTE -->
<div class="modal" id="modalCliente">
  <div class="modal-content">
    <span class="cerrar" onclick="cerrarModal()">×</span>
    <h2>Registrar Cliente</h2>

    <form action="agregar_cliente.php" method="post">
      <input type="text" name="cedula" placeholder="Cédula" required>
      <input type="text" name="nombre" placeholder="Nombre" required>
      <input type="text" name="ciudad" placeholder="Ciudad">
      <input type="text" name="ubicacion" placeholder="Ubicación">
      <input type="email" name="correo" placeholder="Correo electrónico" required>
      <input type="password" name="clave" placeholder="Clave (mín. 4 caracteres)" required>
      <button type="submit">Registrar</button>
    </form>
  </div>
</div>

<!-- MODAL TELÉFONOS -->
<div class="modal" id="modalTelefonos">
  <div class="modal-content">
    <span class="cerrar" onclick="cerrarModalTelefonos()">×</span>
    <h2>Registrar Teléfonos</h2>

    <form action="agregar_telefonos.php" method="post">
      <input type="hidden" name="cedula_cliente" id="cedulaTelefono">

      <label>Teléfono de Casa:</label>
      <input type="text" name="tel_casa" pattern="\d+" required>

      <label>Teléfono Personal:</label>
      <input type="text" name="tel_personal" pattern="\d+" required>

      <label>Teléfono Profesional:</label>
      <input type="text" name="tel_profesional" pattern="\d+" required>

      <button type="submit">Guardar Teléfonos</button>
    </form>
  </div>
</div>

<script>
  function toggleDropdown() {
    const d = document.getElementById("dropdownMenu");
    d.style.display = d.style.display === "block" ? "none" : "block";
  }

  function abrirModal() {
    document.getElementById("modalCliente").style.display = "flex";
  }

  function cerrarModal() {
    document.getElementById("modalCliente").style.display = "none";
  }

  function abrirModalTelefonos(cedula) {
    document.getElementById("cedulaTelefono").value = cedula;
    document.getElementById("modalTelefonos").style.display = "flex";
  }

  function cerrarModalTelefonos() {
    document.getElementById("modalTelefonos").style.display = "none";
  }

  function filtrarClientes() {
    let filtro = document.getElementById("buscar").value.toUpperCase();
    let filas = document.getElementById("tabla-clientes").getElementsByTagName("tr");

    for (let i = 0; i < filas.length; i++) {
      let celdas = filas[i].getElementsByTagName("td");
      let mostrar = false;

      for (let j = 0; j < celdas.length; j++) {
        if (celdas[j] && celdas[j].innerText.toUpperCase().includes(filtro)) {
          mostrar = true;
          break;
        }
      }
      filas[i].style.display = mostrar ? "" : "none";
    }
  }
</script>

</body>
</html>
