<?php
session_start();

// Conexión directa
$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión");
}

$id = $_POST['id_asesoria'] ?? null;

if (!$id) {
    header("Location: asesorias.php?msg=error");
    exit;
}

// Marcar como completada
$sql = $conexion->prepare("
    UPDATE asesoria 
    SET estado = 'completada'
    WHERE id_asesoria = ?
");
$sql->bind_param("i", $id);

if ($sql->execute()) {
    header("Location: asesorias.php?msg=finalizada");
} else {
    header("Location: asesorias.php?msg=error");
}


$conexion->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Completar Asesoría</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f8f9fa;
      padding: 60px;
      text-align: center;
    }
    .mensaje {
      font-size: 1.2rem;
      font-weight: bold;
      color: <?= $error ? "#c0392b" : "#2ecc71" ?>;
      margin-bottom: 20px;
    }
    .volver-btn {
      padding: 10px 20px;
      background-color: #003566;
      color: white;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      text-decoration: none;
    }
    .volver-btn:hover {
      background-color: #0077b6;
    }
  </style>
</head>
<body>

  <div class="mensaje"><?= $mensaje ?></div>
  <a href="asesorias.php" class="volver-btn">← Volver</a>

</body>
</html>
