<?php
// cuentas.php

$adminNombre = "Administrador";
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Cuentas - Administración</title>
  <link rel="stylesheet" href="css/barra.css">
  <style>
  /* ==== MODAL === */
  .modal {
    display: none;
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    justify-content: center;
    align-items: center;
    z-index: 9999;
  }

  .modal-content {
    background-color: #ffffff;
    padding: 30px;
    border-radius: 10px;
    width: 400px;
    max-width: 90%;
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    position: relative;
  }

  .cerrar {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 20px;
    font-weight: bold;
    cursor: pointer;
    color: #003566;
  }

  body {
    margin: 0;
    font-family: 'Segoe UI', sans-serif;
    background-color: #ffffff;
  }

  .menu {
    background-color: #003566;
    color: white;
    padding: 15px 40px;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }

  .menu .logo img {
    height: 50px;
  }

  .menu nav a {
    color: white;
    text-decoration: none;
    margin: 0 10px;
    font-weight: bold;
    transition: color 0.3s ease;
  }

  .menu nav a:hover {
    color: #00b4d8;
  }

  .admin-perfil {
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
    position: relative;
  }

  .admin-perfil img {
    height: 40px;
    width: 40px;
    border-radius: 50%;
  }

  .menu-desplegable {
    display: none;
    position: absolute;
    top: 70px;
    right: 0;
    background-color: white;
    border-radius: 6px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    z-index: 1000;
  }

  .menu-desplegable a {
    display: block;
    padding: 10px 20px;
    color: #003566;
    text-decoration: none;
    font-weight: bold;
    transition: background-color 0.3s ease;
  }

  .menu-desplegable a:hover {
    background-color: #0077b6;
    color: white;
  }

  .volver-panel {
    margin: 30px 40px 0;
  }

  .volver-panel a {
    color: #6c757d;
    font-weight: bold;
    text-decoration: none;
    font-size: 0.95rem;
    transition: color 0.3s ease;
  }

  .volver-panel a:hover {
    color: #0077b6;
  }

  .contenido {
    padding: 40px;
  }

  .contenido h1 {
    color: #003566;
    font-size: 2rem;
  }

  .acciones-superior {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 20px 0;
  }

  .acciones-superior input {
    padding: 10px;
    width: 300px;
    border-radius: 6px;
    border: 1px solid #ccc;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  }

  th, td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid #ccc;
  }

  th {
    background-color: #f0f0f0;
    color: #003566;
  }

  .acciones a {
    padding: 6px 12px;
    color: white;
    border-radius: 5px;
    text-decoration: none;
    font-weight: bold;
    transition: background-color 0.3s ease;
    margin-right: 6px;
  }

  .boton-depositar { background-color: #28a745; }
  .boton-depositar:hover { background-color: #218838; }

  .boton-retirar { background-color: #dc3545; }
  .boton-retirar:hover { background-color: #c82333; }

  .boton-eliminar { background-color: #6c757d;}
  .boton-eliminar:hover { background-color: #495057;}

  </style>

</head>
<body>

  <div class="menu">
    <div class="logo">
      <img src="img/logo.png" alt="Logo del banco">
    </div>
    <nav>
      <a href="prestamos.php">Préstamos</a>
      <a href="clientes.php">Clientes</a>
      <a href="asesorias.php">Asesorías</a>
      <a href="cuentas.php">Cuentas</a>
    </nav>
    <div class="admin-perfil" onclick="toggleMenu()">
      <img src="img/logoadmin.png" alt="Admin">
      <span><?php echo $adminNombre; ?></span>
      <div class="menu-desplegable" id="menuDesplegable">
        <a href="loginadmin.html">Cerrar sesión</a>
      </div>
    </div>
  </div>

  <div class="volver-panel">
    <a href="paneladmin.php">← Volver al Panel</a>
  </div>

  <div class="contenido">
    <h1>Cuentas</h1>
    <div class="acciones-superior">
      <input type="text" id="busqueda" placeholder="Buscar por número o cliente" onkeyup="filtrarTabla()">
    </div>

    <table>
      <thead>
        <tr>
          <th>Número</th>
          <th>Tipo</th>
          <th>Saldo</th>
          <th>Cliente</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody id="tabla-cuentas">

<?php
// ===========================================
// CONEXIÓN Y CONSULTA A LA BASE DE DATOS
// ===========================================
try {
    $conn = new mysqli("localhost", "root", "", "banco");

    if ($conn->connect_error) {
        throw new Exception("Error de conexión: " . $conn->connect_error);
    }

    $query = "
        SELECT 
            c.num_cuenta,
            c.tipo_cuenta,
            c.saldo,
            cl.nombre
        FROM Cuenta c
        JOIN Cliente_Cuenta cc ON c.num_cuenta = cc.num_cuenta
        JOIN Cliente cl ON cc.cedula_cliente = cl.cedula_cliente
        ORDER BY c.num_cuenta
    ";

    $result = $conn->query($query);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>{$row['num_cuenta']}</td>";
            echo "<td>{$row['tipo_cuenta']}</td>";
            echo "<td>$" . number_format($row['saldo'], 2) . "</td>";
            echo "<td>{$row['nombre']}</td>";
            echo "<td class='acciones'>
                    <a href='javascript:void(0);' class='boton-depositar'
                      onclick='abrirDepositoModal({$row['num_cuenta']})'>Depositar</a>
                    <a href='javascript:void(0);' class='boton-retirar'
                      onclick='abrirRetiroModal({$row['num_cuenta']})'>Retirar</a>
                    <a href='javascript:void(0);' class='boton-eliminar'
                      onclick='abrirEliminarModal({$row['num_cuenta']})'>Eliminar</a>
                  </td>";
            echo "</tr>";
        }
    } else {
        echo "<tr><td colspan='5' style='text-align:center;color:gray;'>
              No hay cuentas registradas.
              </td></tr>";
    }

    $conn->close();

} catch (Exception $e) {
    echo "<tr><td colspan='5' style='color:red;'>
          Error: {$e->getMessage()}
          </td></tr>";
}
?>
      </tbody>
    </table>
  </div>

<script>
function toggleMenu() {
  const menu = document.getElementById("menuDesplegable");
  menu.style.display = menu.style.display === "block" ? "none" : "block";
}

window.onclick = function(event) {
  const menu = document.getElementById("menuDesplegable");
  const perfil = document.querySelector(".admin-perfil");
  if (!perfil.contains(event.target)) menu.style.display = "none";
}

function filtrarTabla() {
  const input = document.getElementById("busqueda").value.toLowerCase();
  const filas = document.querySelectorAll("#tabla-cuentas tr");

  filas.forEach(fila => {
    const texto = fila.textContent.toLowerCase();
    fila.style.display = texto.includes(input) ? "" : "none";
  });
}

function abrirDepositoModal(numCuenta) {
  document.getElementById("depositar-numero").value = numCuenta;
  document.getElementById("modalDepositar").style.display = "flex";
}

function cerrarDepositoModal() {
  document.getElementById("modalDepositar").style.display = "none";
}

function abrirRetiroModal(numCuenta) {
  document.getElementById("retirar-numero").value = numCuenta;
  document.getElementById("modalRetirar").style.display = "flex";
}

function cerrarRetiroModal() {
  document.getElementById("modalRetirar").style.display = "none";
}

function abrirEliminarModal(numCuenta) {
  document.getElementById("eliminar-numero").value = numCuenta;
  document.getElementById("modalEliminar").style.display = "flex";
}

function cerrarEliminarModal() {
  document.getElementById("modalEliminar").style.display = "none";
}

</script>

<!-- Modal Depositar -->
<div class="modal" id="modalDepositar">
  <div class="modal-content">
    <span class="cerrar" onclick="cerrarDepositoModal()">×</span>
    <h2>Depositar en cuenta</h2>
    <form action="depositar.php" method="post">
      <input type="hidden" id="depositar-numero" name="num_cuenta">
      <label>Monto a depositar:</label>
      <input type="number" name="monto" min="0.01" step="0.01" required>
      <button type="submit">Depositar</button>
    </form>
  </div>
</div>

<!-- Modal Retirar -->
<div class="modal" id="modalRetirar">
  <div class="modal-content">
    <span class="cerrar" onclick="cerrarRetiroModal()">×</span>
    <h2>Retirar de cuenta</h2>
    <form action="retirar.php" method="post">
      <input type="hidden" id="retirar-numero" name="num_cuenta">
      <label>Monto a retirar:</label>
      <input type="number" name="monto" min="0.01" step="0.01" required>
      <button type="submit">Retirar</button>
    </form>
  </div>
</div>

<!-- Modal Eliminar Cuenta -->
<div class="modal" id="modalEliminar">
  <div class="modal-content">
    <span class="cerrar" onclick="cerrarEliminarModal()">×</span>
    <h2>Eliminar cuenta</h2>

    <p style="color:red; font-weight:bold;">
      ⚠ Esta acción no se puede deshacer
    </p>

    <form action="eliminar_cuenta.php" method="post">
      <input type="hidden" id="eliminar-numero" name="num_cuenta">
      <button type="submit" style="background:#dc3545;color:white;">
        Confirmar eliminación
      </button>
    </form>
  </div>
</div>

</body>
</html>


