<?php
// Obtener datos enviados por POST o GET
$numCuenta = $_REQUEST['num_cuenta'] ?? '';
$montoStr  = $_REQUEST['monto'] ?? '0';

// Función para formateo similar a DecimalFormat de Java
function formatear($numero) {
    return number_format($numero, 2, '.', ',');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Depósito</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f5f7fa;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .mensaje-box {
      background-color: white;
      padding: 40px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      text-align: center;
      max-width: 400px;
      width: 90%;
    }
    .mensaje-box h2 {
      color: #003566;
      margin-bottom: 15px;
    }
    .mensaje-box p {
      margin: 10px 0;
      font-size: 1rem;
    }
    .success {
      color: #28a745;
    }
    .error {
      color: #dc3545;
    }
    .volver-btn {
      margin-top: 20px;
      display: inline-block;
      background-color: #003566;
      color: white;
      padding: 10px 20px;
      text-decoration: none;
      border-radius: 6px;
      font-weight: bold;
      transition: background-color 0.3s ease;
    }
    .volver-btn:hover {
      background-color: #0077b6;
    }
  </style>
</head>
<body>
<div class="mensaje-box">

<?php
try {
    // Convertir monto
    $monto = floatval($montoStr);

    // Conexión
    $conn = new mysqli("localhost", "root", "", "banco");

    if ($conn->connect_error) {
        throw new Exception("Error de conexión: " . $conn->connect_error);
    }

    // SQL: sumar al saldo
    $sql = "UPDATE cuenta SET saldo = saldo + ? WHERE num_cuenta = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ds", $monto, $numCuenta);

    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        // Depósito realizado
        echo "<h2> Depósito exitoso</h2>";
        echo "<p class='success'>Se depositaron $"
   . htmlspecialchars(formatear($monto), ENT_QUOTES, 'UTF-8')
   . " a la cuenta <strong>"
   . htmlspecialchars($numCuenta, ENT_QUOTES, 'UTF-8')
   . "</strong>.</p>";
             " a la cuenta <strong>$numCuenta</strong>.</p>";
    } else {
        // Cuenta no existe
        echo "<h2> Cuenta no encontrada</h2>";
        echo "<p class='error'>No se pudo realizar el depósito. Verifica el número de cuenta.</p>";
    }

    $stmt->close();
    $conn->close();

} catch (Exception $e) {
    echo "<h2>⚠ Error en el depósito</h2>";
    echo "<p class='error'>" . $e->getMessage() . "</p>";
}
?>

<a href="cuentas.php" class="volver-btn">← Volver a Cuentas</a>

</div>
</body>
</html>

