<?php
$conn = new mysqli("localhost", "root", "", "banco");

if ($conn->connect_error) {
    die("Error de conexión");
}

$numCuenta = $_POST['num_cuenta'] ?? null;

if (!$numCuenta) {
    header("Location: cuentas.php");
    exit();
}

/* 1. Verificar saldo */
$sqlSaldo = $conn->prepare("SELECT saldo FROM cuenta WHERE num_cuenta = ?");
$sqlSaldo->bind_param("i", $numCuenta);
$sqlSaldo->execute();
$result = $sqlSaldo->get_result();

if ($result->num_rows === 0) {
    header("Location: cuentas.php?error=cuenta_no_existe");
    exit();
}

$cuenta = $result->fetch_assoc();

/* ❌ SI TIENE SALDO */
if ($cuenta['saldo'] > 0) {
    header("Location: cuentas.php?error=saldo");
    exit();
}

/* 2. Eliminar si saldo = 0 */
$conn->begin_transaction();

try {
    $sql1 = $conn->prepare("DELETE FROM cliente_cuenta WHERE num_cuenta = ?");
    $sql1->bind_param("i", $numCuenta);
    $sql1->execute();

    $sql2 = $conn->prepare("DELETE FROM cuenta WHERE num_cuenta = ?");
    $sql2->bind_param("i", $numCuenta);
    $sql2->execute();

    $conn->commit();
    header("Location: cuentas.php?ok=eliminada");
    exit();

} catch (Exception $e) {
    $conn->rollback();
    header("Location: cuentas.php?error=eliminar");
    exit();
}
?> 
