<?php
// insertar_asesoria.php
// Alberto Davis, María Ferrer, Miguel Rodríguez, Yessica Cuevas, Víctor Lee

header("Content-Type: text/html; charset=UTF-8");

$cedula = $_POST['cedula_cliente'] ?? '';
$fechaStr = $_POST['fecha_asesoria'] ?? '';

$error = false;
$mensaje = "";

// Conexión a la base de datos
$conn = new mysqli("localhost", "root", "", "banco");

if ($conn->connect_error) {
    die("❌ Error de conexión: " . $conn->connect_error);
}

try {

    // Verificar que el cliente exista
    $stmt = $conn->prepare("SELECT COUNT(*) FROM Cliente WHERE cedula_cliente = ?");
    $stmt->bind_param("s", $cedula);
    $stmt->execute();
    $stmt->bind_result($existe);
    $stmt->fetch();
    $stmt->close();

    if ($existe == 0) {
        $error = true;
        $mensaje = "❌ El cliente con cédula $cedula no existe.";
    } else {

        // Validar fecha futura
        $fechaIngresada = new DateTime($fechaStr);
        $hoy = new DateTime();

        if ($fechaIngresada <= $hoy) {
            $error = true;
            $mensaje = "❌ La fecha de la asesoría debe ser posterior a hoy.";
        } else {

            // Insertar asesoría
            $stmt = $conn->prepare(
                "INSERT INTO Asesoria (cedula_cliente, fecha_asesoria, estado) VALUES (?, ?, 'Pendiente')"
            );
            $fechaSQL = $fechaIngresada->format("Y-m-d");
            $stmt->bind_param("ss", $cedula, $fechaSQL);
            $stmt->execute();
            $stmt->close();

            $mensaje = "✅ Asesoría registrada exitosamente.";
        }
    }

} catch (Exception $e) {
    $error = true;
    $mensaje = "❌ Error al registrar asesoría: " . $e->getMessage();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Resultado Asesoría</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f8f9fa;
      padding: 60px;
      text-align: center;
    }
    .mensaje {
      font-size: 1.2rem;
      font-weight: bold;
      color: <?= $error ? "#c0392b" : "#2ecc71" ?>;
      margin-bottom: 20px;
    }
    .volver-btn {
      padding: 10px 20px;
      background-color: #003566;
      color: white;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      text-decoration: none;
    }
    .volver-btn:hover {
      background-color: #0077b6;
    }
  </style>
</head>
<body>

<div class="mensaje"><?= htmlspecialchars($mensaje, ENT_QUOTES, 'UTF-8') ?></div>
  <a href="asesorias.php" class="volver-btn">← Volver</a>

</body>

</html>
