<?php
// loginadmin.php
// Alberto Davis, María Ferrer, Miguel Rodríguez, Yessica Cuevas, Víctor Lee

include 
session_start();

$usuario = $_POST['correo'] ?? null;
$clave   = $_POST['clave'] ?? null;
$remember = $_POST['remember'] ?? null;

if ($usuario !== null && $clave !== null) {

    // Conexión a MySQL
    $conn = new mysqli("localhost", "root", "", "banco");

    if ($conn->connect_error) {
        die("<p style='color:red;'>Error de conexión: " . $conn->connect_error . "</p>");
    }

    // Consulta de validación
    $sql = "SELECT * FROM Empleado WHERE correo_electronico = ? AND clave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $usuario, $clave);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {

        // Guardar sesión
        $_SESSION["admin"] = $row["nombre"];

        // Remember Me
        if ($remember === "on") {
            setcookie("correoRecordado", $usuario, time() + (7 * 24 * 60 * 60), "/"); // 7 días
        } else {
            setcookie("correoRecordado", "", time() - 3600, "/"); // Eliminar cookie
        }

        // Redirigir al panel
        header("Location: paneladmin.php");
        exit;

    } else {
        echo "<p style='color:red; text-align:center;'>Usuario o contraseña incorrectos.</p>";
    }

    $stmt->close();
    $conn->close();
}
?>
