<?php
session_start();

$usuario = $_POST['usuario'] ?? null;
$clave   = $_POST['clave'] ?? null;
$minutosBloqueo = 5;


if ($usuario === null || $clave === null) {
    header("Location: logincliente.html");
    exit;
}

$conn = new mysqli("localhost", "root", "", "banco");
if ($conn->connect_error) {
    die("Error de conexión");
}

// 1️⃣ Buscar cliente (sin validar clave aún)
$sql = "SELECT * FROM cliente 
        WHERE correo_electronico = ? OR cedula_cliente = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $usuario, $usuario);
$stmt->execute();
$result = $stmt->get_result();

if (!$row = $result->fetch_assoc()) {
    // Usuario no existe
    header("Location: logincliente.html?error=credenciales");
    exit;
}

// 2️⃣ Verificar si está bloqueado
if ($row['bloqueado_hasta'] !== null && strtotime($row['bloqueado_hasta']) > time()) {
    echo "<script>
        alert('Cuenta bloqueada temporalmente. Intenta más tarde.');
        window.location.href = 'logincliente.html';
    </script>";
    exit;
}

// 3️⃣ Verificar contraseña
if ($row['clave_hash'] === $clave) {

    // ✅ LOGIN CORRECTO → limpiar intentos
    $reset = $conn->prepare("
        UPDATE cliente 
        SET intentos_fallidos = 0, bloqueado_hasta = NULL
        WHERE cedula_cliente = ?
    ");
    $reset->bind_param("s", $row['cedula_cliente']);
    $reset->execute();

    $_SESSION["cliente_logueado"] = $row["cedula_cliente"];
    $_SESSION["cliente_nombre"]   = $row["nombre"];

    header("Location: HOME.html");
    exit;

} else {

    // ❌ CLAVE INCORRECTA
    $intentos = $row['intentos_fallidos'] + 1;

    if ($intentos >= 3) {
        // 🔒 Bloquear cuenta
        $bloqueo = date("Y-m-d H:i:s", strtotime("+5 minutes"));

        $upd = $conn->prepare("
            UPDATE cliente 
            SET intentos_fallidos = ?, bloqueado_hasta = ?
            WHERE cedula_cliente = ?
        ");
        $upd->bind_param("iss", $intentos, $bloqueo, $row['cedula_cliente']);
        $upd->execute();

        echo "<script>
            alert('Cuenta bloqueada por 5 minutos por múltiples intentos fallidos.');
            window.location.href = 'logincliente.html';
        </script>";
        exit;
    } else {
        // Aumentar intentos
        $upd = $conn->prepare("
            UPDATE cliente 
            SET intentos_fallidos = ?
            WHERE cedula_cliente = ?
        ");
        $upd->bind_param("is", $intentos, $row['cedula_cliente']);
        $upd->execute();

        echo "<script>
            alert('Usuario o contraseña incorrectos. Intento $intentos de 3.');
            window.location.href = 'logincliente.html';
        </script>";
        exit;
    }
}
?>

