<?php
// pagarcompleto.php
// Alberto Davis, María Ferrer, Miguel Rodríguez, Yessica Cuevas, Víctor Lee

$numParam = $_GET['num_prestamo'] ?? null;

if ($numParam !== null) {

    $num = intval($numParam);

    $conn = new mysqli("localhost", "root", "", "banco");

    if ($conn->connect_error) {
        die("<p>Error de conexión: " . $conn->connect_error . "</p>");
    }

    // 1. Calcular lo que falta por pagar del préstamo
    $consulta = "
        SELECT P.importe - IFNULL(SUM(A.importe_pagado), 0) AS restante
        FROM Prestamo P
        LEFT JOIN Abono A ON P.num_prestamo = A.num_prestamo
        WHERE P.num_prestamo = ?
        GROUP BY P.importe
    ";

    $ps1 = $conn->prepare($consulta);
    $ps1->bind_param("i", $num);
    $ps1->execute();
    $rs = $ps1->get_result();

    $restante = 0;
    if ($row = $rs->fetch_assoc()) {
        $restante = $row["restante"];
    }

    $rs->close();
    $ps1->close();

    // 2. Insertar abono final si todavía queda saldo pendiente
    if ($restante > 0) {
        $insertAbono = "INSERT INTO Abono (num_prestamo, importe_pagado) VALUES (?, ?)";
        $ps2 = $conn->prepare($insertAbono);
        $ps2->bind_param("id", $num, $restante);
        $ps2->execute();
        $ps2->close();
    }

    // 3. Cambiar el estado del préstamo a finalizado
    $update = "UPDATE Prestamo SET estado = 'finalizado' WHERE num_prestamo = ?";
    $ps3 = $conn->prepare($update);
    $ps3->bind_param("i", $num);
    $ps3->execute();
    $ps3->close();

    $conn->close();

    // Redirigir igual que en JSP
    header("Location: prestamos.php");
    exit;

} else {
    echo "<p>❗ Préstamo no especificado.</p>";
}
?>
