<?php
session_start();

/*
CONTROL DE SESIÓN (opcional por ahora)
if (!isset($_SESSION['admin'])) {
    header("Location: loginadmin.html");
    exit();
}
*/

$adminNombre = "Administrador"; // temporal
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Panel del Administrador</title>
  <link rel="stylesheet" href="barra.css">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #ffffff;
    }

    .bienvenida {
      text-align: center;
      font-size: 1.8rem;
      font-weight: bold;
      margin: 50px 0 60px;
      color: #003566;
    }

    .contenido {
      display: flex;
      justify-content: center;
      gap: 80px;
      padding: 20px 60px 80px;
      flex-wrap: wrap;
    }

    .tarjeta {
      background: linear-gradient(135deg, #0077b6, #00b4d8);
      color: white;
      padding: 40px 30px;
      border-radius: 18px;
      width: 310px;
      text-align: center;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .tarjeta:hover {
      transform: translateY(-10px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.2);
    }

    .tarjeta img {
      width: 120px;
      height: 120px;
      object-fit: contain;
      margin-bottom: 20px;
    }

    .tarjeta h2 {
      margin-bottom: 20px;
      font-size: 1.4rem;
    }

    .tarjeta a {
      display: inline-block;
      background-color: white;
      color: #003566;
      padding: 12px 20px;
      font-weight: bold;
      border-radius: 8px;
      text-decoration: none;
      transition: background-color 0.3s ease, color 0.3s ease;
    }

    .tarjeta a:hover {
      background-color: #003566;
      color: white;
    }

    /* Estilo del perfil */
    .admin-perfil {
      display: flex;
      align-items: center;
      gap: 10px;
      cursor: pointer;
      position: relative;
    }

    .admin-perfil img {
      height: 40px;
      width: 40px;
      border-radius: 50%;
    }

    .menu-desplegable {
      display: none;
      position: absolute;
      top: 70px;
      right: 0;
      background-color: white;
      border-radius: 6px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.2);
      z-index: 1000;
    }

    .menu-desplegable a {
      display: block;
      padding: 10px 20px;
      color: #003566;
      text-decoration: none;
      font-weight: bold;
      transition: background-color 0.3s ease;
    }

    .menu-desplegable a:hover {
      background-color: #0077b6;
      color: white;
    }

    /* Barra superior */
    .menu {
      background-color: #003566;
      color: white;
      padding: 15px 40px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .menu nav a {
      color: white;
      text-decoration: none;
      margin: 0 30px;
      font-weight: bold;
      transition: color 0.3s ease;
    }

    .menu nav a:hover {
      color: #00b4d8;
    }

    .menu .logo img {
      height: 50px;
    }
  </style>
</head>
<body>

  <!-- Barra superior -->
  <div class="menu">
    <div class="logo">
      <img src="img/logo.png" alt="Logo del banco">
    </div>
    
    <div class="admin-perfil" onclick="toggleMenu()">
      <img src="img/logoadmin.png" alt="Admin">
      <span><?= $adminNombre ?></span>
      <div class="menu-desplegable" id="menuDesplegable">
        <a href="loginadmin.html">Cerrar sesión</a>
      </div>
    </div>
  </div>

  <div class="bienvenida">
    ¡Hola, <?= $adminNombre ?>! Bienvenido al Panel de Administración

  </div>

  <div class="contenido">

    <div class="tarjeta">
      <img src="img/clientespanel.png" alt="Clientes">
      <h2>Clientes</h2>
      <a href="clientes.php">Ver clientes</a>
    </div>

    <div class="tarjeta">
      <img src="img/cuentaspanel.png" alt="Cuentas">
      <h2>Cuentas</h2>
      <a href="cuentas.php">Crear cuenta</a>
    </div>

    <div class="tarjeta">
      <img src="img/prestamospanel.png" alt="Préstamos">
      <h2>Préstamos</h2>
      <a href="prestamos.php">Administrar préstamos</a>
    </div>

    <div class="tarjeta">
      <img src="img/clientespanel.png" alt="Asesorías">
      <h2>Asesorías</h2>
      <a href="asesorias.php">Ver asesorías</a>
    </div>

  </div>

  <!-- Script para menú -->
  <script>
    function toggleMenu() {
      const menu = document.getElementById("menuDesplegable");
      menu.style.display = menu.style.display === "block" ? "none" : "block";
    }

    // Cerrar si se hace click fuera
    window.addEventListener("click", function(e) {
      const adminBox = document.querySelector(".admin-perfil");
      const menu = document.getElementById("menuDesplegable");

      if (!adminBox.contains(e.target)) {
        menu.style.display = "none";
      }
    });
  </script>

</body>
</html>
