<?php
// ---------- CONFIGURACIÓN ----------
$adminNombre = "Administrador";

$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

// Buscar por cédula
$cedulaBuscada = isset($_GET['cedula']) ? trim($_GET['cedula']) : "";

// Consulta
$sql = "SELECT 
            P.num_prestamo, 
            P.cedula_cliente, 
            P.importe, 
            P.tasa_interes, 
            P.cantidad_meses,
            P.estado,
            (P.importe - IFNULL(SUM(A.importe_pagado),0)) AS cuota_restante
        FROM Prestamo P 
        LEFT JOIN Abono A ON P.num_prestamo = A.num_prestamo";

if (!empty($cedulaBuscada)) {
    $sql .= " WHERE P.cedula_cliente = ?";
}

$sql .= " GROUP BY P.num_prestamo";

$stmt = $conexion->prepare($sql);
if (!empty($cedulaBuscada)) {
    $stmt->bind_param("s", $cedulaBuscada);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Préstamos - Administración</title>
<link rel="stylesheet" href="css/barra.css">

<style>
    .btn-aprobar {
      background-color: #00b894;
      color: white;
      border: none;
      padding: 6px 10px;
      border-radius: 5px;
      cursor: pointer;
    }

    .btn-rechazar {
      background-color: #d63031;
      color: white;
      border: none;
      padding: 6px 10px;
      border-radius: 5px;
      cursor: pointer;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #ffffff;
    }

    .menu {
      display: flex;
      justify-content: space-between;
      align-items: center;
      background-color: #003566;
      padding: 15px 40px;
      color: white;
    }

    .menu nav a {
      margin: 0 10px;
      color: white;
      text-decoration: none;
      font-weight: bold;
    }
    .menu nav a:hover {
      text-decoration: underline;
    }

    .logo img {
      height: 40px;
    }

    .perfil-container {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .perfil-container img {
      height: 30px;
      border-radius: 50%;
    }

    .dropdown {
      display: none;
      position: absolute;
      top: 60px;
      right: 40px;
      background-color: white;
      border: 1px solid #ccc;
      border-radius: 5px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    }

    .dropdown a {
      display: block;
      padding: 10px;
      color: #003566;
      text-decoration: none;
    }
    .dropdown a:hover {
      background-color: #f0f0f0;
    }

    .volver-panel {
      margin: 30px 40px 0;
    }

    .volver-panel a {
      color: #6c757d;
      font-weight: bold;
      text-decoration: none;
      font-size: 0.95rem;
    }

    .volver-panel a:hover {
      color: #0077b6;
    }

    .contenido {
      padding: 40px;
    }

    .contenido h1 {
      color: #003566;
      font-size: 2rem;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    th, td {
      padding: 12px;
      text-align: left;
      border-bottom: 1px solid #ccc;
    }

    th {
      background-color: #f0f0f0;
      color: #003566;
    }

    .estado { font-weight: bold; }

    .cedula.aprobado { color: green; }
    .cedula.rechazado { color: red; }
    .cedula.pendiente { color: orange; }

    /* MODAL */
    .modal {
      display: none;
      position: fixed;
      z-index: 1000;
      left: 0; top: 0;
      width: 100%; height: 100%;
      background-color: rgba(0, 0, 0, 0.5);
      justify-content: center;
      align-items: center;
    }

    .modal-content {
      background-color: white;
      padding: 30px;
      border-radius: 10px;
      width: 400px;
      text-align: center;
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }

    .modal-content button {
      margin: 10px;
      padding: 10px 20px;
      font-weight: bold;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }

    .btn-cancelar { background-color: #888; color: white; }
    .btn-confirmar { background-color: #27ae60; color: white; }
  </style>
</head>

<body>

<!-- BARRA SUPERIOR -->
<div class="menu">
  <div class="logo"><img src="img/logo.png" alt="Logo del banco"></div>

  <nav>
    <a href="#">Préstamos</a>
    <a href="clientes.php">Clientes</a>
    <a href="asesorias.php">Asesorías</a>
    <a href="cuentas.php">Cuentas</a>
  </nav>

  <div class="perfil-container">
      <img src="img/logoadmin.png" alt="Perfil">
      <span><?php echo $adminNombre; ?></span>
      <div class="dropdown" id="dropdownMenu">
        <a href="loginadmin.html">Cerrar sesión</a>
      </div>
  </div>
</div>

<div class="volver-panel">
  <a href="paneladmin.php">← Volver al Panel</a>
</div>

<div class="contenido">

  <h1>Lista de Préstamos</h1>

  <form method="get" action="prestamos.php" style="margin: 20px 0;">
    <input type="text" name="cedula" placeholder="Buscar por cédula..." 
           value="<?php echo htmlspecialchars($cedulaBuscada); ?>"
           style="padding: 8px; border-radius: 6px; border: 1px solid #ccc; width: 250px;">
    <button type="submit" style="padding: 8px 16px; border-radius: 6px; border: none; background-color: #003566; color: white;">Buscar</button>
  </form>

<table>
  <tr>
    <th>Cédula</th>
    <th>Importe</th>
    <th>Interés</th>
    <th>Meses</th>
    <th>Estado</th>
    <th>Cuota restante</th>
    <th>Acciones</th>
  </tr>

<?php while ($row = $result->fetch_assoc()): 
    $estado = strtolower($row['estado']);
?>

<tr>
  <td class="cedula <?= $estado ?>">
    <?= $row['cedula_cliente'] ?>
  </td>

  <td><?= number_format($row['importe'], 2) ?></td>
  <td><?= number_format($row['tasa_interes'], 2) ?>%</td>
  <td><?= $row['cantidad_meses'] ?></td>

  <td class="estado"><?= ucfirst($estado) ?></td>

  <td><?= number_format($row['cuota_restante'], 2) ?></td>

  <td>

    <!-- SI ESTÁ PENDIENTE -->
<?php if ($estado === "pendiente"): ?>
    <form action="solicitar_prestamo.php" method="post" style="display:inline;">
        <input type="hidden" name="num_prestamo" value="<?php echo $row['num_prestamo']; ?>">
        <input type="hidden" name="accion" value="aprobar">
        <button class="btn-aprobar">Aprobar</button>
    </form>
    <!-- RECHAZAR -->
  <form action="solicitar_prestamo.php" method="post" style="display:inline;">
      <input type="hidden" name="num_prestamo" value="<?= $row['num_prestamo']; ?>">
      <input type="hidden" name="accion" value="rechazar">
      <button class="btn-rechazar">Rechazar</button>
  </form>
    <?php endif; ?>

    <!-- SI ESTÁ ACTIVO -->
    <?php if ($estado === "activo"): ?>
      <button class="btn-aprobar"
        onclick="abrirAbono(<?= $row['num_prestamo'] ?>)">
        Abonar
      </button>

      <button class="btn-rechazar"
        onclick="confirmarPago(<?= $row['num_prestamo'] ?>)">
        Pagar completo
      </button>
    <?php endif; ?>

    <!-- SI ESTÁ FINALIZADO -->
    <?php if ($estado === "finalizado"): ?>
      <span style="color:gray;font-weight:bold;">✔ Completado</span>
    <?php endif; ?>

  </td>
</tr>

<?php endwhile; ?>
</table>

</div>

<!-- MODALES (IGUALES) -->
<div class="modal" id="modal-confirmar">
  <div class="modal-content">
    <h2>¿Confirmar pago completo?</h2>
    <p>Esto marcará el préstamo como <strong>finalizado</strong>.</p>

    <form action="pagarcompleto.php" method="post">
      <input type="hidden" name="num_prestamo" id="hiddenNum">
      <button type="submit" class="btn-confirmar">Confirmar</button>
      <button type="button" class="btn-cancelar" onclick="cerrarModal()">Cancelar</button>
    </form>
  </div>
</div>

<div class="modal" id="modal-abono">
  <div class="modal-content">
    <h2>Registrar abono</h2>
    
    <form action="abono.php" method="post">
      <input type="hidden" name="num_prestamo" id="abonoNum">

      <label>Monto a abonar:</label>
      <input type="number" name="importe" step="0.01" min="0.01" required>
      <br><br>

      <button type="submit" class="btn-confirmar">Confirmar abono</button>
      <button type="button" class="btn-cancelar" onclick="cerrarAbono()">Cancelar</button>
    </form>
  </div>
</div>

<script>
function confirmarPago(num) {
  document.getElementById("hiddenNum").value = num;
  document.getElementById("modal-confirmar").style.display = "flex";
}

function cerrarModal() {
  document.getElementById("modal-confirmar").style.display = "none";
}

function abrirAbono(num) {
  document.getElementById("abonoNum").value = num;
  document.getElementById("modal-abono").style.display = "flex";
}

function cerrarAbono() {
  document.getElementById("modal-abono").style.display = "none";
}
</script>

</body>
</html>