<?php
$ok    = $_GET['ok'] ?? null;
$error = $_GET['error'] ?? null;
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Solicitud de prestamos</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f5f7fa;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .mensaje-box {
      background-color: white;
      padding: 40px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      text-align: center;
      max-width: 420px;
      width: 90%;
    }
    .mensaje-box h2 {
      color: #003566;
      margin-bottom: 15px;
    }
    .mensaje-box p {
      margin: 10px 0;
      font-size: 1rem;
    }
    .success {
      color: #28a745;
      font-weight: bold;
    }
    .error {
      color: #dc3545;
      font-weight: bold;
    }
    .volver-btn {
      margin-top: 25px;
      display: inline-block;
      background-color: #003566;
      color: white;
      padding: 10px 22px;
      text-decoration: none;
      border-radius: 6px;
      font-weight: bold;
      transition: background-color 0.3s ease;
    }
    .volver-btn:hover {
      background-color: #0077b6;
    }
  </style>
</head>
<body>

<div class="mensaje-box">

<?php if ($ok): ?>
  <h2> Solicitud enviada</h2>
  <p class="success">
    Tu solicitud de prestamo fue enviada correctamente.
  </p>

<?php elseif ($error): ?>
  <h2> Error</h2>
  <p class="error">
    No se pudo enviar la solicitud. Inténtalo nuevamente.
  </p>

<?php else: ?>
  <h2> Información</h2>
  <p>
    Acceso inválido a esta página.
  </p>
<?php endif; ?>

<a href="cliente_panel.php" class="volver-btn">← Volver al panel</a>

</div>

</body>
</html>
