<?php

$cedula       = $_POST["cedula"] ?? null;
$nombre       = $_POST["nombre"] ?? null;
$ciudad       = $_POST["ciudad"] ?? null;
$ubicacion    = $_POST["ubicacion"] ?? null;
$correo       = $_POST["correo"] ?? null;
$clave        = $_POST["clave"] ?? null;
$telCasa        = $_POST["tel_casa"] ?? null;
$telPersonal    = $_POST["tel_personal"] ?? null;
$telProfesional = $_POST["tel_profesional"] ?? null;

// Validación básica
if ($cedula && $nombre && $clave && strlen($clave) >= 4) {

    try {
        // Conexión MySQL
        $conn = new mysqli("localhost", "root", "", "banco");

        if ($conn->connect_error) {
            throw new Exception("Error de conexión: " . $conn->connect_error);
        }

        // Verificar si existe la cédula
    $stmtCedula = $conn->prepare("SELECT COUNT(*) FROM cliente WHERE cedula_cliente = ?");
    $stmtCedula->bind_param("s", $cedula);
    $stmtCedula->execute();
    $stmtCedula->bind_result($countCedula);
    $stmtCedula->fetch();
    $stmtCedula->close();

    if ($countCedula > 0) {
        mostrarModal(
            "❌ Cédula duplicada",
            "Ya existe un cliente registrado con la cédula <strong>$cedula</strong>.",
            "registro_cliente.php"
        );
        exit;
    }


        // Verificar si existe el correo
        $stmtCorreo = $conn->prepare("SELECT COUNT(*) FROM cliente WHERE correo_electronico = ?");
        $stmtCorreo->bind_param("s", $correo);
        $stmtCorreo->execute();
        $stmtCorreo->bind_result($count);
        $stmtCorreo->fetch();
        $stmtCorreo->close();

        if ($count > 0) {
            mostrarModal("❌ Correo ya registrado", "Ya existe un cliente con este correo electrónico.", "registro_cliente.php");
            exit;
        }

        // Insertar cliente
        $sqlInsert = "INSERT INTO cliente (cedula_cliente, nombre, ciudad, ubicacion, correo_electronico, clave_hash)
                      VALUES (?, ?, ?, ?, ?, ?)";

        $stmtCliente = $conn->prepare($sqlInsert);
        $stmtCliente->bind_param("ssssss", $cedula, $nombre, $ciudad, $ubicacion, $correo, $clave);

        if ($stmtCliente->execute()) {

// Insertar teléfonos
$sqlTel = "INSERT INTO TelefonoCliente 
           (cedula_cliente, tipo, codigo_area, numero) 
           VALUES (?, ?, ?, ?)";

$stmtTel = $conn->prepare($sqlTel);

// Teléfono personal (casa)
if (!empty($telCasa)) {
    $tipo = "personal";
    $codigo = "507"; // Panamá
    $stmtTel->bind_param("ssss", $cedula, $tipo, $codigo, $telCasa);
    $stmtTel->execute();
}

// Teléfono personal
if (!empty($telPersonal)) {
    $tipo = "personal";
    $codigo = "507";
    $stmtTel->bind_param("ssss", $cedula, $tipo, $codigo, $telPersonal);
    $stmtTel->execute();
}

// Teléfono trabajo
if (!empty($telProfesional)) {
    $tipo = "trabajo";
    $codigo = "507";
    $stmtTel->bind_param("ssss", $cedula, $tipo, $codigo, $telProfesional);
    $stmtTel->execute();
}

$stmtTel->close();
$stmtCliente->close();
$conn->close();

            mostrarModal("✅ Registro exitoso", "¡Cliente <strong>$nombre</strong> registrado correctamente!", "logincliente.html");
            exit;

        } else {
            mostrarModal("❌ Error al registrar", "No se pudo guardar el cliente. Intenta nuevamente.", "registro_cliente.php");
            exit;
        }

    } catch (Exception $e) {
        mostrarModal("⚠️ Error de servidor", $e->getMessage(), "registro_cliente.php");
        exit;
    }

} else {
    mostrarModal("❌ Datos inválidos", "Todos los campos son requeridos. La clave debe tener al menos 4 caracteres.", "registro_cliente.php");
    exit;
}


// ==========================
// FUNCIÓN PARA MOSTRAR MODAL
// ==========================
function mostrarModal($titulo, $mensaje, $link)
{
    $tituloSeguro  = htmlspecialchars($titulo, ENT_QUOTES, 'UTF-8');
    $mensajeSeguro = htmlspecialchars($mensaje, ENT_QUOTES, 'UTF-8');
    $linkSeguro    = htmlspecialchars($link, ENT_QUOTES, 'UTF-8');

    echo "
    <div class='modal-msg'>
        <div class='modal-box'>
            <h2>$tituloSeguro</h2>
            <p>$mensajeSeguro</p>
            <a href='$linkSeguro' class='btn-modal'>Aceptar</a>
        </div>
    </div>";
}
?>
    <style>
    .modal-msg {
        position: fixed;
        top: 0; left: 0;
        height: 100vh; width: 100vw;
        background: rgba(0,0,0,0.6);
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .modal-box {
        background: white;
        padding: 2rem;
        border-radius: 10px;
        text-align: center;
        max-width: 400px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }
    .modal-box h2 {
        margin-bottom: 10px;
    }
    .modal-box a {
        display: inline-block;
        margin-top: 10px;
        text-decoration: none;
        color: #0077B6;
        font-weight: bold;
    }
    .modal-box a:hover {
        color: #03045E;
    }
    </style>
    ";
}
?>


