<?php
// retirar.php

$numCuenta = $_POST['num_cuenta'] ?? null;
$montoStr  = $_POST['monto'] ?? null;

$mensaje = "";
$tipo    = "";

if ($numCuenta && $montoStr) {

    $monto = floatval($montoStr);

    try {
        $conn = new mysqli("localhost", "root", "", "banco");
        if ($conn->connect_error) {
            throw new Exception("Error de conexión");
        }

        // Obtener saldo
        $stmt = $conn->prepare("SELECT saldo FROM cuenta WHERE num_cuenta = ?");
        $stmt->bind_param("i", $numCuenta);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($row = $res->fetch_assoc()) {

            $saldoActual = floatval($row['saldo']);

            if ($saldoActual >= $monto) {

                // Retiro
                $stmt2 = $conn->prepare(
                    "UPDATE cuenta SET saldo = saldo - ? WHERE num_cuenta = ?"
                );
                $stmt2->bind_param("di", $monto, $numCuenta);
                $stmt2->execute();

                if ($stmt2->affected_rows > 0) {
                    $mensaje = "Se retiraron $" . number_format($monto, 2) .
                               " de la cuenta $numCuenta.";
                    $tipo = "success";
                } else {
                    $mensaje = "No se pudo actualizar el saldo.";
                    $tipo = "error";
                }

                $stmt2->close();

            } else {
                $mensaje = "Saldo insuficiente. Saldo actual: $" .
                           number_format($saldoActual, 2);
                $tipo = "error";
            }

        } else {
            $mensaje = "La cuenta no existe.";
            $tipo = "error";
        }

        $stmt->close();
        $conn->close();

    } catch (Exception $e) {
        $mensaje = "Error en el retiro.";
        $tipo = "error";
    }

} else {
    $mensaje = "Datos incompletos.";
    $tipo = "error";
}
?>


<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Retiro</title>

<style>
body {
  font-family: 'Segoe UI', sans-serif;
  background-color: #f5f7fa;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  margin: 0;
}
.mensaje-box {
  background-color: white;
  padding: 40px;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
  text-align: center;
  max-width: 400px;
  width: 90%;
}
.mensaje-box h2 {
  color: #003566;
  margin-bottom: 15px;
}
.success { color: #28a745; }
.error { color: #dc3545; }

.volver-btn {
  margin-top: 20px;
  display: inline-block;
  background-color: #003566;
  color: white;
  padding: 10px 20px;
  text-decoration: none;
  border-radius: 6px;
  font-weight: bold;
  transition: background-color 0.3s ease;
}
.volver-btn:hover {
  background-color: #0077b6;
}
</style>

</head>
<body>

<div class="mensaje-box">
    <h2><?= ($tipo === "success" ? "✔ Retiro exitoso" : "⚠ Aviso") ?></h2>
<p class="<?= htmlspecialchars($tipo, ENT_QUOTES, 'UTF-8') ?>">
    <?= htmlspecialchars($mensaje, ENT_QUOTES, 'UTF-8') ?>
</p>

    <a href="cuentas.php" class="volver-btn">← Volver a Cuentas</a>
</div>

</body>
</html>

