<?php
session_start();

// PRECONDICIÓN: cliente logueado
if (!isset($_SESSION['cliente_logueado'])) {
    header("Location: logincliente.html");
    exit;
}

$conexion = new mysqli("localhost", "root", "", "banco");
if ($conexion->connect_error) {
    die("Error de conexión");
}

$cedula = $_SESSION['cliente_logueado'];
$tipo = trim($_POST['tipo_asesoria'] ?? "");
$descripcion = trim($_POST['descripcion'] ?? "");

// Validación de campos
if ($tipo === "" || $descripcion === "") {
    header("Location: cliente_panel.php?error_asesoria=campos");
    exit;
}

// Validar asesoría pendiente existente
$check = $conexion->prepare("
    SELECT COUNT(*) 
    FROM asesoria 
    WHERE cedula_cliente = ? AND estado = 'pendiente'
");
$check->bind_param("s", $cedula);
$check->execute();
$check->bind_result($existe);
$check->fetch();
$check->close();

if ($existe > 0) {
    header("Location: cliente_panel.php?error_asesoria=pendiente");
    exit;
}

// Registrar asesoría
$sql = $conexion->prepare("
    INSERT INTO asesoria 
    (cedula_cliente, tipo_asesoria, descripcion, fecha_asesoria, estado)
    VALUES (?, ?, ?, CURDATE(), 'pendiente')
");
$sql->bind_param("sss", $cedula, $tipo, $descripcion);

if ($sql->execute()) {
    header("Location: cliente_panel.php?ok_asesoria=1");
} else {
    header("Location: cliente_panel.php?error_asesoria=db");
}
?>  

