<?php
session_start();
$conexion = new mysqli("localhost", "root", "", "banco");

if ($conexion->connect_error) {
    die("Error de conexión");
}

/* =====================================================
   CASO 1: ACCIÓN DESDE prestamos.php (ADMIN)
===================================================== */
if (isset($_POST['accion']) && isset($_POST['num_prestamo'])) {

    $accion = $_POST['accion'];
    $num = $_POST['num_prestamo'];

    if ($accion === "aprobar") {
        $sql = $conexion->prepare("
            UPDATE prestamo 
            SET estado = 'activo'
            WHERE num_prestamo = ?
        ");
    } elseif ($accion === "rechazar") {
        $sql = $conexion->prepare("
            UPDATE prestamo 
            SET estado = 'rechazado'
            WHERE num_prestamo = ?
        ");
    } else {
        die("Acción no válida");
    }

    $sql->bind_param("i", $num);
    $sql->execute();

    header("Location: prestamos.php");
    exit;
}

/* =====================================================
   CASO 2: SOLICITUD DESDE cliente_panel.php (CLIENTE)
===================================================== */

if (!isset($_SESSION['cliente_logueado'])) {
    die("Sesión no válida. Inicia sesión.");
}

$cedula = $_SESSION['cliente_logueado'];
$importe = $_POST['importe'] ?? null;
$meses = $_POST['meses'] ?? null;

if (!$importe || !$meses) {
    die("Datos incompletos");
}

/* INSERTAR SOLICITUD */
$sql = $conexion->prepare("
    INSERT INTO prestamo 
    (cedula_cliente, importe, tasa_interes, cantidad_meses, estado)
    VALUES (?, ?, 5.5, ?, 'pendiente')
");

$sql->bind_param("sdi", $cedula, $importe, $meses);

if ($sql->execute()) {
    header("Location: cliente_panel.php?ok_prestamo=1");
} else {
    header("Location: cliente_panel.php?error_prestamo=1");
}
exit;
?>  

