/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.aa;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler rd;
    private final Tracker re;
    private final Context mContext;
    private ExceptionParser rf;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.rd = originalHandler;
        this.re = tracker;
        this.rf = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        aa.v("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.rf;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.rf = exceptionParser;
    }

    public void uncaughtException(Thread t2, Throwable e2) {
        String string2 = "UncaughtException";
        if (this.rf != null) {
            String string3 = t2 != null ? t2.getName() : null;
            string2 = this.rf.getDescription(string3, e2);
        }
        aa.v("Tracking Exception: " + string2);
        this.re.send(new HitBuilders.ExceptionBuilder().setDescription(string2).setFatal(true).build());
        GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        if (this.rd != null) {
            aa.v("Passing exception to original handler.");
            this.rd.uncaughtException(t2, e2);
        }
    }
}

