/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.er;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    static final Api.b<dq> va = new Api.b<dq>(){

        public dq c(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            er.b(apiOptions, (Object)"Setting the API options is required.");
            er.b(apiOptions instanceof CastOptions, (Object)"Must provide valid CastOptions!");
            CastOptions castOptions = (CastOptions)apiOptions;
            return new dq(context, looper, castOptions.wv, castOptions.wx, castOptions.ww, connectionCallbacks, onConnectionFailedListener);
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.c(context, looper, ee2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api API = new Api(va, new Scope[0]);
    public static final CastApi CastApi = new CastApi.a();

    private Cast() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class a
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient client) throws IOException, IllegalStateException {
                try {
                    client.a(va).cZ();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient client, final String namespace, final String message) {
                return client.b(new b(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.a(namespace, message, this);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.x(2001);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId) {
                return client.b(new c(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.a(applicationId, false, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId, final boolean relaunchIfRunning) {
                return client.b(new c(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.a(applicationId, relaunchIfRunning, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId, final String sessionId) {
                return client.b(new c(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.b(applicationId, sessionId, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId) {
                return client.b(new c(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.b(applicationId, null, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client) {
                return client.b(new c(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.b(null, null, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient client) {
                return client.b(new b(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.e(this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client) {
                return client.b(new b(){

                    protected void a(dq dq2) throws RemoteException {
                        try {
                            dq2.a("", this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client, final String sessionId) {
                return client.b(new b(){

                    protected void a(dq dq2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)sessionId)) {
                            this.c(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            dq2.a(sessionId, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.x(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient client, double volume) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    client.a(va).a(volume);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient client) throws IllegalStateException {
                return client.a(va).da();
            }

            @Override
            public void setMute(GoogleApiClient client, boolean mute) throws IOException, IllegalStateException {
                try {
                    client.a(va).t(mute);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient client) throws IllegalStateException {
                return client.a(va).isMute();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient client) throws IllegalStateException {
                return client.a(va).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient client) throws IllegalStateException {
                return client.a(va).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient client, String namespace, MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
                try {
                    client.a(va).a(namespace, callbacks);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient client, String namespace) throws IOException, IllegalArgumentException {
                try {
                    client.a(va).Q(namespace);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends a<Status> {
        private b() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class c
    extends a<ApplicationConnectionResult> {
        private c() {
        }

        public ApplicationConnectionResult h(final Status status) {
            return new ApplicationConnectionResult(){

                public Status getStatus() {
                    return status;
                }

                public boolean getWasLaunched() {
                    return false;
                }

                public String getSessionId() {
                    return null;
                }

                public String getApplicationStatus() {
                    return null;
                }

                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.h(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class a<R extends Result>
    extends a.a<R, dq>
    implements PendingResult<R> {
        public a() {
            super(va);
        }

        public void x(int n2) {
            this.a(this.d(new Status(n2)));
        }

        public void c(int n2, String string) {
            this.a(this.d(new Status(n2, string, null)));
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements GoogleApiClient.ApiOptions {
        final CastDevice wv;
        final Listener ww;
        private final int wx;

        private CastOptions(Builder builder) {
            this.wv = builder.wy;
            this.ww = builder.wz;
            this.wx = builder.wA;
        }

        public static Builder builder(CastDevice castDevice, Listener castListener) {
            return new Builder(castDevice, castListener);
        }

        public static final class Builder {
            CastDevice wy;
            Listener wz;
            private int wA;

            private Builder(CastDevice castDevice, Listener castListener) {
                er.b(castDevice, (Object)"CastDevice parameter cannot be null");
                er.b(castListener, (Object)"CastListener parameter cannot be null");
                this.wy = castDevice;
                this.wz = castListener;
                this.wA = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean enabled) {
                this.wA = enabled ? (this.wA |= 1) : (this.wA &= 0xFFFFFFFE);
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static abstract class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationDisconnected(int statusCode) {
        }

        public void onVolumeChanged() {
        }
    }
}

