/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.internal.dr;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    private long wY;
    private MediaInfo wQ;
    private double wZ;
    private int xa;
    private int xb;
    private long xc;
    private long xd;
    private double xe;
    private boolean xf;
    private JSONObject wP;

    public MediaStatus(JSONObject json) throws JSONException {
        this.a(json, 0);
    }

    public long cU() {
        return this.wY;
    }

    public int getPlayerState() {
        return this.xa;
    }

    public int getIdleReason() {
        return this.xb;
    }

    public double getPlaybackRate() {
        return this.wZ;
    }

    public MediaInfo getMediaInfo() {
        return this.wQ;
    }

    public long getStreamPosition() {
        return this.xc;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.xd & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.xe;
    }

    public boolean isMute() {
        return this.xf;
    }

    public JSONObject getCustomData() {
        return this.wP;
    }

    public int a(JSONObject jSONObject, int n2) throws JSONException {
        long l2;
        long l3;
        double d2;
        int n3 = 0;
        long l4 = jSONObject.getLong("mediaSessionId");
        if (l4 != this.wY) {
            this.wY = l4;
            n3 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n4 = 0;
            String string = jSONObject.getString("playerState");
            if (string.equals("IDLE")) {
                n4 = 1;
            } else if (string.equals("PLAYING")) {
                n4 = 2;
            } else if (string.equals("PAUSED")) {
                n4 = 3;
            } else if (string.equals("BUFFERING")) {
                n4 = 4;
            }
            if (n4 != this.xa) {
                this.xa = n4;
                n3 |= 2;
            }
            if (n4 == 1 && jSONObject.has("idleReason")) {
                int n5 = 0;
                string = jSONObject.getString("idleReason");
                if (string.equals("CANCELLED")) {
                    n5 = 2;
                } else if (string.equals("INTERRUPTED")) {
                    n5 = 3;
                } else if (string.equals("FINISHED")) {
                    n5 = 1;
                } else if (string.equals("ERROR")) {
                    n5 = 4;
                }
                if (n5 != this.xb) {
                    this.xb = n5;
                    n3 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.wZ != (d2 = jSONObject.getDouble("playbackRate"))) {
            this.wZ = d2;
            n3 |= 2;
        }
        if (jSONObject.has("currentTime") && (n2 & 2) == 0 && (l3 = dr.b(jSONObject.getDouble("currentTime"))) != this.xc) {
            this.xc = l3;
            n3 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l2 = jSONObject.getLong("supportedMediaCommands")) != this.xd) {
            this.xd = l2;
            n3 |= 2;
        }
        if (jSONObject.has("volume") && (n2 & 1) == 0) {
            boolean bl2;
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d3 = jSONObject2.getDouble("level");
            if (d3 != this.xe) {
                this.xe = d3;
                n3 |= 2;
            }
            if ((bl2 = jSONObject2.getBoolean("muted")) != this.xf) {
                this.xf = bl2;
                n3 |= 2;
            }
        }
        if (jSONObject.has("customData")) {
            this.wP = jSONObject.getJSONObject("customData");
            n3 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.wQ = new MediaInfo(jSONObject3);
            n3 |= 2;
            if (jSONObject3.has("metadata")) {
                n3 |= 4;
            }
        }
        return n3;
    }
}

