/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.fy;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvitationEntity
extends fy
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new a();
    private final int wj;
    private final GameEntity Jq;
    private final String GP;
    private final long Jr;
    private final int Js;
    private final ParticipantEntity Jt;
    private final ArrayList<ParticipantEntity> Ju;
    private final int Jv;
    private final int Jw;

    InvitationEntity(Invitation invitation) {
        this.wj = 2;
        this.Jq = new GameEntity(invitation.getGame());
        this.GP = invitation.getInvitationId();
        this.Jr = invitation.getCreationTimestamp();
        this.Js = invitation.getInvitationType();
        this.Jv = invitation.getVariant();
        this.Jw = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.Ju = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.Ju.add((ParticipantEntity)participant2.freeze());
        }
        er.b(participant, (Object)"Must have a valid inviter!");
        this.Jt = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.wj = versionCode;
        this.Jq = game;
        this.GP = invitationId;
        this.Jr = creationTimestamp;
        this.Js = invitationType;
        this.Jt = inviter;
        this.Ju = participants;
        this.Jv = variant;
        this.Jw = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.wj;
    }

    @Override
    public Game getGame() {
        return this.Jq;
    }

    @Override
    public String getInvitationId() {
        return this.GP;
    }

    @Override
    public Participant getInviter() {
        return this.Jt;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Jr;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Ju);
    }

    @Override
    public int getInvitationType() {
        return this.Js;
    }

    @Override
    public int getVariant() {
        return this.Jv;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.Jw;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return ep.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return ep.equal(invitation2.getGame(), invitation.getGame()) && ep.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && ep.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && ep.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && ep.equal(invitation2.getInviter(), invitation.getInviter()) && ep.equal(invitation2.getParticipants(), invitation.getParticipants()) && ep.equal(invitation2.getVariant(), invitation.getVariant()) && ep.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return ep.e(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).a("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.dZ()) {
            com.google.android.gms.games.multiplayer.a.a(this, dest, flags);
        } else {
            this.Jq.writeToParcel(dest, flags);
            dest.writeString(this.GP);
            dest.writeLong(this.Jr);
            dest.writeInt(this.Js);
            this.Jt.writeToParcel(dest, flags);
            int n2 = this.Ju.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Ju.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends com.google.android.gms.games.multiplayer.a {
        a() {
        }

        public InvitationEntity an(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.dY());
            if (bl2 || InvitationEntity.ae(InvitationEntity.class.getCanonicalName())) {
                return super.an(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            int n5 = 0;
            return new InvitationEntity(2, gameEntity, string, l2, n3, participantEntity, arrayList, n2, n5);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.an(x0);
        }
    }
}

