/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.cw;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.cy;
import com.google.android.gms.internal.cz;
import com.google.android.gms.internal.da;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cv {
    private static final Object op = new Object();
    private static boolean pO = true;
    private static String pP;
    private static boolean pQ;

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", cv.b(context, string2));
        httpURLConnection.setUseCaches(false);
    }

    public static boolean h(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl2 = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            da.w("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl2 = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                da.w(String.format(string2, "keyboard"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                da.w(String.format(string2, "keyboardHidden"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                da.w(String.format(string2, "orientation"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                da.w(String.format(string2, "screenLayout"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                da.w(String.format(string2, "uiMode"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                da.w(String.format(string2, "screenSize"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                da.w(String.format(string2, "smallestScreenSize"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public static boolean a(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public static boolean aS() {
        return pO;
    }

    public static int aT() {
        return Build.VERSION.SDK_INT >= 9 ? 6 : 0;
    }

    public static int aU() {
        return Build.VERSION.SDK_INT >= 9 ? 7 : 1;
    }

    public static void a(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new cy(context, string2, string3).start();
        }
    }

    public static String a(Readable readable) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while ((n2 = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n2);
        }
        return stringBuilder.toString();
    }

    public static void i(Context context) {
        if (pQ) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new a(), intentFilter);
        pQ = true;
    }

    public static void a(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(cv.b(context, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String b(final Context context, String string2) {
        Object object = op;
        synchronized (object) {
            if (pP != null) {
                return pP;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                pP = cx.getDefaultUserAgent(context);
            } else if (!cz.aX()) {
                cz.pT.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = op;
                        synchronized (object) {
                            pP = cv.j(context);
                            op.notifyAll();
                        }
                    }
                });
                while (pP == null) {
                    try {
                        op.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return pP;
                    }
                }
            } else {
                pP = cv.j(context);
            }
            pP = pP + " (Mobile; " + string2 + ")";
            return pP;
        }
    }

    private static String j(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public static boolean a(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String p(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public static JSONObject m(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                cv.a(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private static JSONObject a(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            cv.a(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private static JSONArray a(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            cv.a(jSONArray, obj);
        }
        return jSONArray;
    }

    static JSONArray a(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            cv.a(jSONArray, object);
        }
        return jSONArray;
    }

    private static void a(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)cv.a((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)cv.m(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)cv.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)cv.a((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private static void a(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)cv.a((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)cv.m(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)cv.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)cv.a(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public static void a(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            cw.a(webView);
        }
    }

    public static void b(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            cw.b(webView);
        }
    }

    static {
        pQ = false;
    }

    private static final class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                pO = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                pO = false;
            }
        }
    }
}

