/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dr;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.eh;
import com.google.android.gms.internal.em;
import com.google.android.gms.internal.en;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class dq
extends eh<ds> {
    private static final du xE = new du("CastClientImpl");
    private ApplicationMetadata xF;
    private final CastDevice xG;
    private final Cast.Listener wz;
    private final Handler mHandler;
    private final dt xH;
    private final Map<String, Cast.MessageReceivedCallback> xI;
    private final long xJ;
    private String xK;
    private boolean xf;
    private boolean xL;
    private boolean xM;
    private double xe;
    private final AtomicLong xN;
    private String xO;
    private String xP;
    private Bundle xQ;
    private Map<Long, a.c<Status>> xR;
    private a.c<Cast.ApplicationConnectionResult> xS;
    private a.c<Status> xT;
    private static final Object xU = new Object();
    private static final Object xV = new Object();

    public dq(Context context, Looper looper, CastDevice castDevice, long l2, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, (String[])null);
        this.xG = castDevice;
        this.wz = listener;
        this.xJ = l2;
        this.mHandler = new Handler(looper);
        this.xI = new HashMap<String, Cast.MessageReceivedCallback>();
        this.xM = false;
        this.xF = null;
        this.xK = null;
        this.xe = 0.0;
        this.xf = false;
        this.xN = new AtomicLong(0L);
        this.xR = new HashMap<Long, a.c<Status>>();
        this.xH = new dt.a(){

            public void z(int n2) {
                xE.b("ICastDeviceControllerListener.onDisconnected: %d", n2);
                dq.this.xM = false;
                dq.this.xF = null;
                if (n2 != 0) {
                    dq.this.O(2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void a(ApplicationMetadata applicationMetadata, String string, String string2, boolean bl2) {
                dq.this.xF = applicationMetadata;
                dq.this.xO = applicationMetadata.getApplicationId();
                dq.this.xP = string2;
                Object object = xU;
                synchronized (object) {
                    if (dq.this.xS != null) {
                        dq.this.xS.b(new a(new Status(0), applicationMetadata, string, string2, bl2));
                        dq.this.xS = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void A(int n2) {
                Object object = xU;
                synchronized (object) {
                    if (dq.this.xS != null) {
                        dq.this.xS.b(new a(new Status(n2)));
                        dq.this.xS = null;
                    }
                }
            }

            public void B(int n2) {
                this.D(n2);
            }

            public void C(int n2) {
                this.D(n2);
            }

            public void onApplicationDisconnected(final int statusCode) {
                dq.this.xO = null;
                dq.this.xP = null;
                if (this.D(statusCode)) {
                    return;
                }
                if (dq.this.wz != null) {
                    dq.this.mHandler.post(new Runnable(){

                        public void run() {
                            if (dq.this.wz != null) {
                                dq.this.wz.onApplicationDisconnected(statusCode);
                            }
                        }
                    });
                }
            }

            public void b(final String string, final double d2, final boolean bl2) {
                dq.this.mHandler.post(new Runnable(){

                    public void run() {
                        dq.this.a(string, d2, bl2);
                    }
                });
            }

            public void d(final String string, final String string2) {
                xE.b("Receive (type=text, ns=%s) %s", string, string2);
                dq.this.mHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Cast.MessageReceivedCallback messageReceivedCallback;
                        Map map = dq.this.xI;
                        synchronized (map) {
                            messageReceivedCallback = (Cast.MessageReceivedCallback)dq.this.xI.get(string);
                        }
                        if (messageReceivedCallback != null) {
                            messageReceivedCallback.onMessageReceived(dq.this.xG, string, string2);
                        } else {
                            xE.b("Discarded message for unknown namespace '%s'", string);
                        }
                    }
                });
            }

            public void b(String string, byte[] byArray) {
                xE.b("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string, byArray.length);
            }

            public void a(String string, long l2, int n2) {
                this.b(l2, n2);
            }

            public void a(String string, long l2) {
                this.b(l2, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void b(long l2, int n2) {
                a.c c2 = null;
                Map map = dq.this.xR;
                synchronized (map) {
                    c2 = (a.c)dq.this.xR.remove(l2);
                }
                if (c2 != null) {
                    c2.b(new Status(n2));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean D(int n2) {
                Object object = xV;
                synchronized (object) {
                    if (dq.this.xT != null) {
                        dq.this.xT.b(new Status(n2));
                        dq.this.xT = null;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 || n2 == 1001) {
            this.xM = true;
            this.xL = true;
        } else {
            this.xM = false;
        }
        int n3 = n2;
        if (n2 == 1001) {
            this.xQ = new Bundle();
            this.xQ.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.a(n3, iBinder, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        try {
            block7: {
                try {
                    if (!this.isConnected()) break block7;
                    Map<String, Cast.MessageReceivedCallback> map = this.xI;
                    synchronized (map) {
                        this.xI.clear();
                    }
                    ((ds)this.eb()).disconnect();
                }
                catch (RemoteException remoteException) {
                    xE.b("Error while disconnecting the controller interface: %s", remoteException.getMessage());
                    Object var4_5 = null;
                    super.disconnect();
                }
            }
            Object var4_4 = null;
            super.disconnect();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            super.disconnect();
            throw throwable;
        }
    }

    @Override
    public Bundle cY() {
        if (this.xQ != null) {
            Bundle bundle = this.xQ;
            this.xQ = null;
            return bundle;
        }
        return super.cY();
    }

    @Override
    protected String aF() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @Override
    protected String aG() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected ds v(IBinder iBinder) {
        return ds.a.w(iBinder);
    }

    @Override
    protected void a(en en2, eh.e e2) throws RemoteException {
        Bundle bundle = new Bundle();
        xE.b("getServiceFromBroker(): mLastApplicationId=%s, mLastSessionId=%s", this.xO, this.xP);
        this.xG.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.xJ);
        if (this.xO != null) {
            bundle.putString("last_application_id", this.xO);
            if (this.xP != null) {
                bundle.putString("last_session_id", this.xP);
            }
        }
        en2.a((em)e2, 4323000, this.getContext().getPackageName(), this.xH.asBinder(), bundle);
    }

    public void a(String string, String string2, a.c<Status> c2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string == null || string.length() > 128) {
            throw new IllegalArgumentException("Invalid namespace length");
        }
        if (string2.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        this.db();
        long l2 = this.xN.incrementAndGet();
        ((ds)this.eb()).a(string, string2, l2);
        this.xR.put(l2, c2);
    }

    public void a(String string, boolean bl2, a.c<Cast.ApplicationConnectionResult> c2) throws IllegalStateException, RemoteException {
        this.d(c2);
        ((ds)this.eb()).e(string, bl2);
    }

    public void b(String string, String string2, a.c<Cast.ApplicationConnectionResult> c2) throws IllegalStateException, RemoteException {
        this.d(c2);
        ((ds)this.eb()).e(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(a.c<Cast.ApplicationConnectionResult> c2) {
        Object object = xU;
        synchronized (object) {
            if (this.xS != null) {
                this.xS.b(new a(new Status(2002)));
            }
            this.xS = c2;
        }
    }

    public void e(a.c<Status> c2) throws IllegalStateException, RemoteException {
        this.f(c2);
        ((ds)this.eb()).df();
    }

    public void a(String string, a.c<Status> c2) throws IllegalStateException, RemoteException {
        this.f(c2);
        ((ds)this.eb()).R(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f(a.c<Status> c2) {
        Object object = xV;
        synchronized (object) {
            if (this.xT != null) {
                c2.b(new Status(2001));
                return;
            }
            this.xT = c2;
        }
    }

    public void cZ() throws IllegalStateException, RemoteException {
        ((ds)this.eb()).cZ();
    }

    public void a(double d2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        ((ds)this.eb()).a(d2, this.xe, this.xf);
    }

    public void t(boolean bl2) throws IllegalStateException, RemoteException {
        ((ds)this.eb()).a(bl2, this.xe, this.xf);
    }

    public double da() throws IllegalStateException {
        this.db();
        return this.xe;
    }

    public boolean isMute() throws IllegalStateException {
        this.db();
        return this.xf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(String string, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        this.Q(string);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.xI;
            synchronized (map) {
                this.xI.put(string, messageReceivedCallback);
            }
            ((ds)this.eb()).S(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Q(String string) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.xI;
        synchronized (map) {
            messageReceivedCallback = this.xI.remove(string);
        }
        if (messageReceivedCallback != null) {
            try {
                ((ds)this.eb()).T(string);
            }
            catch (IllegalStateException illegalStateException) {
                xE.a(illegalStateException, "Error unregistering namespace (%s): %s", string, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.db();
        return this.xF;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.db();
        return this.xK;
    }

    private void a(String string, double d2, boolean bl2) {
        boolean bl3 = false;
        if (!dr.a(string, this.xK)) {
            this.xK = string;
            bl3 = true;
        }
        if (this.wz != null && (bl3 || this.xL)) {
            this.wz.onApplicationStatusChanged();
        }
        bl3 = false;
        if (d2 != this.xe) {
            this.xe = d2;
            bl3 = true;
        }
        if (bl2 != this.xf) {
            this.xf = bl2;
            bl3 = true;
        }
        xE.b("hasChange=%b, mFirstStatusUpdate=%b", bl3, this.xL);
        if (this.wz != null && (bl3 || this.xL)) {
            this.wz.onVolumeChanged();
        }
        this.xL = false;
    }

    private void db() throws IllegalStateException {
        if (!this.xM) {
            throw new IllegalStateException("not connected to a device");
        }
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.v(iBinder);
    }

    private static final class a
    implements Cast.ApplicationConnectionResult {
        private final Status vl;
        private final ApplicationMetadata yb;
        private final String yc;
        private final String pz;
        private final boolean yd;

        public a(Status status, ApplicationMetadata applicationMetadata, String string, String string2, boolean bl2) {
            this.vl = status;
            this.yb = applicationMetadata;
            this.yc = string;
            this.pz = string2;
            this.yd = bl2;
        }

        public a(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.vl;
        }

        public ApplicationMetadata getApplicationMetadata() {
            return this.yb;
        }

        public String getApplicationStatus() {
            return this.yc;
        }

        public String getSessionId() {
            return this.pz;
        }

        public boolean getWasLaunched() {
            return this.yd;
        }
    }
}

