/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.ei;
import com.google.android.gms.internal.ej;
import com.google.android.gms.internal.em;
import com.google.android.gms.internal.en;
import com.google.android.gms.internal.er;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class eh<T extends IInterface>
implements GooglePlayServicesClient,
Api.a,
ei.b {
    private final Context mContext;
    private final Looper zs;
    final Handler mHandler;
    private T Bv;
    private final ArrayList<b<?>> Bw = new ArrayList();
    private f Bx;
    private volatile int By = 1;
    private final String[] Bz;
    boolean BA = false;
    private final ei zx;
    public static final String[] BB = new String[]{"service_esmobile", "service_googleme"};

    protected eh(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = er.f(context);
        this.zs = er.b(looper, (Object)"Looper must not be null");
        this.zx = new ei(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.Bz = stringArray;
        this.registerConnectionCallbacks(er.f(connectionCallbacks));
        this.registerConnectionFailedListener(er.f(onConnectionFailedListener));
    }

    protected eh(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String aF();

    protected abstract String aG();

    protected abstract T p(IBinder var1);

    @Override
    public void connect() {
        this.BA = true;
        this.By = 2;
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.By = 1;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.Bx != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.Bv = null;
            ej.y(this.mContext).b(this.aF(), this.Bx);
        }
        this.Bx = new f();
        boolean bl2 = ej.y(this.mContext).a(this.aF(), this.Bx);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.aF()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.By == 3;
    }

    @Override
    public boolean isConnecting() {
        return this.By == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.BA = false;
        ArrayList<b<?>> arrayList = this.Bw;
        synchronized (arrayList) {
            int n2 = this.Bw.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Bw.get(i2).ed();
            }
            this.Bw.clear();
        }
        this.By = 1;
        this.Bv = null;
        if (this.Bx != null) {
            ej.y(this.mContext).b(this.aF(), this.Bx);
            this.Bx = null;
        }
    }

    public void O(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zs;
    }

    public final String[] ea() {
        return this.Bz;
    }

    protected final void x(IBinder iBinder) {
        try {
            en en2 = en.a.z(iBinder);
            this.a(en2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(en var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void bm() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle cY() {
        return null;
    }

    protected final T eb() {
        this.bm();
        return this.Bv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.Bw;
        synchronized (arrayList) {
            this.Bw.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean dC() {
        return this.BA;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zx.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zx.registerConnectionFailedListener(listener);
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.zx.registerConnectionCallbacks(new c(listener));
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.zx.isConnectionCallbacksRegistered(new c(listener));
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.zx.unregisterConnectionCallbacks(new c(listener));
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.zx.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.zx.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.zx.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends em.a {
        private eh BF;

        public e(eh eh2) {
            this.BF = eh2;
        }

        public void b(int n2, IBinder iBinder, Bundle bundle) {
            er.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.BF);
            this.BF.a(n2, iBinder, bundle);
            this.BF = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle BH;
        public final IBinder BI;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.BI = iBinder;
            this.BH = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                eh.this.By = 1;
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.BI.getInterfaceDescriptor();
                        if (eh.this.aG().equals(string2)) {
                            eh.this.Bv = eh.this.p(this.BI);
                            if (eh.this.Bv != null) {
                                eh.this.By = 3;
                                eh.this.zx.bo();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    ej.y(eh.this.mContext).b(eh.this.aF(), eh.this.Bx);
                    eh.this.Bx = null;
                    eh.this.By = 1;
                    eh.this.Bv = null;
                    eh.this.zx.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    eh.this.By = 1;
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.BH != null) {
                        pendingIntent = (PendingIntent)this.BH.getParcelable("pendingIntent");
                    }
                    if (eh.this.Bx != null) {
                        ej.y(eh.this.mContext).b(eh.this.aF(), eh.this.Bx);
                        eh.this.Bx = null;
                    }
                    eh.this.By = 1;
                    eh.this.Bv = null;
                    eh.this.zx.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener BG;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.BG = onConnectionFailedListener;
        }

        public void onConnectionFailed(ConnectionResult result) {
            this.BG.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.BG.equals(((g)other).BG);
            }
            return this.BG.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks BE;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.BE = connectionCallbacks;
        }

        public void onConnected(Bundle connectionHint) {
            this.BE.onConnected(connectionHint);
        }

        public void onConnectionSuspended(int cause) {
            this.BE.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.BE.equals(((c)other).BE);
            }
            return this.BE.equals(other);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder zU;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.zU = dataHolder;
        }

        @Override
        protected final void a(TListener TListener) {
            this.a(TListener, this.zU);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void cP() {
            if (this.zU != null) {
                this.zU.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean BD;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.BD = false;
        }

        protected abstract void a(TListener var1);

        protected abstract void cP();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ec() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.BD) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.a(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.cP();
                    throw runtimeException;
                }
            } else {
                this.cP();
            }
            b2 = this;
            synchronized (b2) {
                this.BD = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.ed();
            ArrayList arrayList = eh.this.Bw;
            synchronized (arrayList) {
                eh.this.Bw.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ed() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !eh.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.cP();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                eh.this.zx.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                eh.this.By = 1;
                eh.this.Bv = null;
                eh.this.zx.P((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !eh.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.cP();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.ec();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            eh.this.x(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            eh.this.mHandler.sendMessage(eh.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

