/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ev<K, V> {
    private final LinkedHashMap<K, V> Ch;
    private int size;
    private int Ci;
    private int Cj;
    private int Ck;
    private int Cl;
    private int Cm;
    private int Cn;

    public ev(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.Ci = n2;
        this.Ch = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        ev<K, V> ev2 = this;
        synchronized (ev2) {
            object = this.Ch.get(key);
            if (object != null) {
                ++this.Cm;
                return object;
            }
            ++this.Cn;
        }
        ev2 = this.create(key);
        if (ev2 == null) {
            return null;
        }
        ev ev3 = this;
        synchronized (ev3) {
            ++this.Ck;
            object = this.Ch.put(key, ev2);
            if (object != null) {
                this.Ch.put(key, object);
            } else {
                this.size += this.c(key, ev2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, ev2, object);
            return object;
        }
        this.trimToSize(this.Ci);
        return (V)ev2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        ev ev2 = this;
        synchronized (ev2) {
            ++this.Cj;
            this.size += this.c(key, value);
            v2 = this.Ch.put(key, value);
            if (v2 != null) {
                this.size -= this.c(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.Ci);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            ev ev2 = this;
            synchronized (ev2) {
                if (this.size < 0 || this.Ch.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.Ch.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.Ch.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.Ch.remove(k2);
                this.size -= this.c(k2, v2);
                ++this.Cl;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int c(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.Cm + this.Cn;
        int n3 = n2 != 0 ? 100 * this.Cm / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.Ci, this.Cm, this.Cn, n3);
    }
}

