/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.eh;
import com.google.android.gms.internal.en;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.je;
import com.google.android.gms.internal.jf;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jg
extends eh<je> {
    private final Activity nd;
    private final int Zw;
    private final String vi;
    private final int mTheme;

    @Deprecated
    public jg(Activity activity, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, int n2, String string2, int n3) {
        this(activity, activity.getMainLooper(), (GoogleApiClient.ConnectionCallbacks)new eh.c(connectionCallbacks), (GoogleApiClient.OnConnectionFailedListener)new eh.g(onConnectionFailedListener), n2, string2, n3);
    }

    public jg(Activity activity, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n2, String string2, int n3) {
        super((Context)activity, looper, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.nd = activity;
        this.Zw = n2;
        this.vi = string2;
        this.mTheme = n3;
    }

    @Override
    protected String aF() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    @Override
    protected String aG() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    protected je aE(IBinder iBinder) {
        return je.a.aC(iBinder);
    }

    @Override
    protected void a(en en2, eh.e e2) throws RemoteException {
        en2.a(e2, 4323000);
    }

    public void checkForPreAuthorization(int requestCode) {
        Bundle bundle = this.kx();
        a a2 = new a(requestCode);
        try {
            ((je)this.eb()).a(bundle, a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            a2.a(8, false, null);
        }
    }

    public void changeMaskedWallet(String googleTransactionId, String merchantTransactionId, int requestCode) {
        Bundle bundle = this.kx();
        a a2 = new a(requestCode);
        try {
            ((je)this.eb()).a(googleTransactionId, merchantTransactionId, bundle, a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            a2.a(8, (MaskedWallet)null, (Bundle)null);
        }
    }

    public void loadMaskedWallet(MaskedWalletRequest request, int requestCode) {
        Bundle bundle = this.kx();
        a a2 = new a(requestCode);
        try {
            ((je)this.eb()).a(request, bundle, (jf)a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            a2.a(8, (MaskedWallet)null, (Bundle)null);
        }
    }

    public void loadFullWallet(FullWalletRequest request, int requestCode) {
        a a2 = new a(requestCode);
        Bundle bundle = this.kx();
        try {
            ((je)this.eb()).a(request, bundle, (jf)a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            a2.a(8, (FullWallet)null, (Bundle)null);
        }
    }

    public void notifyTransactionStatus(NotifyTransactionStatusRequest request) {
        Bundle bundle = this.kx();
        try {
            ((je)this.eb()).a(request, bundle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private Bundle kx() {
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", this.Zw);
        bundle.putString("androidPackageName", this.nd.getPackageName());
        if (!TextUtils.isEmpty((CharSequence)this.vi)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(this.vi, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", this.mTheme);
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.aE(iBinder);
    }

    final class a
    extends jf.a {
        private final int Bq;

        public a(int n2) {
            this.Bq = n2;
        }

        public void a(int n2, MaskedWallet maskedWallet, Bundle bundle) {
            ConnectionResult connectionResult;
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n2, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(jg.this.nd, this.Bq);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                int n3;
                Intent intent = new Intent();
                if (connectionResult.isSuccess()) {
                    n3 = -1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET", (Parcelable)maskedWallet);
                } else {
                    n3 = n2 == 408 ? 0 : 1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n2);
                }
                PendingIntent pendingIntent2 = jg.this.nd.createPendingResult(this.Bq, intent, 0x40000000);
                if (pendingIntent2 == null) {
                    Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onMaskedWalletLoaded");
                    return;
                }
                try {
                    pendingIntent2.send(n3);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        public void a(int n2, FullWallet fullWallet, Bundle bundle) {
            ConnectionResult connectionResult;
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n2, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(jg.this.nd, this.Bq);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                int n3;
                Intent intent = new Intent();
                if (connectionResult.isSuccess()) {
                    n3 = -1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET", (Parcelable)fullWallet);
                } else {
                    n3 = n2 == 408 ? 0 : 1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n2);
                }
                PendingIntent pendingIntent2 = jg.this.nd.createPendingResult(this.Bq, intent, 0x40000000);
                if (pendingIntent2 == null) {
                    Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onFullWalletLoaded");
                    return;
                }
                try {
                    pendingIntent2.send(n3);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        public void a(int n2, boolean bl2, Bundle bundle) {
            Intent intent = new Intent();
            intent.putExtra("com.google.android.gm.wallet.EXTRA_IS_USER_PREAUTHORIZED", bl2);
            PendingIntent pendingIntent = jg.this.nd.createPendingResult(this.Bq, intent, 0x40000000);
            if (pendingIntent == null) {
                Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onPreAuthorizationDetermined");
                return;
            }
            try {
                pendingIntent.send(-1);
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            }
        }

        public void e(int n2, Bundle bundle) {
            er.b(bundle, (Object)"Bundle should not be null");
            PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            ConnectionResult connectionResult = new ConnectionResult(n2, pendingIntent);
            if (connectionResult.hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(jg.this.nd, this.Bq);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                Log.e((String)"WalletClientImpl", (String)("Create Wallet Objects confirmation UI will not be shown connection result: " + connectionResult));
                Intent intent = new Intent();
                intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", 413);
                PendingIntent pendingIntent2 = jg.this.nd.createPendingResult(this.Bq, intent, 0x40000000);
                if (pendingIntent2 == null) {
                    Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onWalletObjectsCreated");
                    return;
                }
                try {
                    pendingIntent2.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }
    }
}

