/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ViewSwitcher;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.af;
import com.google.android.gms.internal.ag;
import com.google.android.gms.internal.ai;
import com.google.android.gms.internal.ap;
import com.google.android.gms.internal.az;
import com.google.android.gms.internal.bd;
import com.google.android.gms.internal.bf;
import com.google.android.gms.internal.bo;
import com.google.android.gms.internal.bq;
import com.google.android.gms.internal.br;
import com.google.android.gms.internal.bu;
import com.google.android.gms.internal.by;
import com.google.android.gms.internal.cd;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cp;
import com.google.android.gms.internal.cr;
import com.google.android.gms.internal.ct;
import com.google.android.gms.internal.cv;
import com.google.android.gms.internal.cz;
import com.google.android.gms.internal.da;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.dd;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.k;
import com.google.android.gms.internal.l;
import com.google.android.gms.internal.u;
import com.google.android.gms.internal.w;
import com.google.android.gms.internal.z;
import java.util.HashSet;

public final class v
extends ag.a
implements ap,
az,
br,
bu,
by.a,
u {
    private final bf kH;
    private final a kI;
    private final w kJ;

    public v(Context context, ab ab2, String string2, bf bf2, db db2) {
        this.kI = new a(context, ab2, string2, db2);
        this.kH = bf2;
        this.kJ = new w(this);
        da.u("Use AdRequest.Builder.addTestDevice(\"" + cz.l(context) + "\") to get test ads on this device.");
        cv.i(context);
    }

    public void destroy() {
        er.ac("destroy must be called on the main UI thread.");
        this.kI.kO = null;
        this.kI.kT = null;
        this.kJ.cancel();
        this.stopLoading();
        if (this.kI.kK != null) {
            this.kI.kK.removeAllViews();
        }
        if (this.kI.kR != null && this.kI.kR.nu != null) {
            this.kI.kR.nu.destroy();
        }
    }

    public b P() {
        er.ac("getAdFrame must be called on the main UI thread.");
        return c.h(this.kI.kK);
    }

    public ab Q() {
        er.ac("getAdSize must be called on the main UI thread.");
        return this.kI.kQ;
    }

    public boolean isReady() {
        er.ac("isLoaded must be called on the main UI thread.");
        return this.kI.kP == null && this.kI.kR != null;
    }

    public boolean a(z z2) {
        dd dd2;
        er.ac("loadAd must be called on the main UI thread.");
        if (this.kI.kP != null) {
            da.w("An ad request is already in progress. Aborting.");
            return false;
        }
        if (this.kI.kQ.lo && this.kI.kR != null) {
            da.w("An interstitial is already loading. Aborting.");
            return false;
        }
        if (!this.ae()) {
            return false;
        }
        da.u("Starting ad request.");
        this.kJ.cancel();
        cd.a a2 = this.c(z2);
        if (this.kI.kQ.lo) {
            dd2 = dd.a(this.kI.kL, this.kI.kQ, false, false, this.kI.kM, this.kI.kN);
            dd2.bb().a(this, null, this, this, true);
        } else {
            View view = this.kI.kK.getNextView();
            if (view instanceof dd) {
                dd2 = (dd)view;
                dd2.a(this.kI.kL, this.kI.kQ);
            } else {
                if (view != null) {
                    this.kI.kK.removeView(view);
                }
                dd2 = dd.a(this.kI.kL, this.kI.kQ, false, false, this.kI.kM, this.kI.kN);
                if (this.kI.kQ.lp == null) {
                    this.b((View)dd2);
                }
            }
            dd2.bb().a(this, this, this, this, false);
        }
        this.kI.kP = by.a(this.kI.kL, a2, this.kI.kM, dd2, this.kH, this);
        return true;
    }

    public void a(cn cn2) {
        boolean bl2;
        this.kI.kP = null;
        if (cn2.errorCode != -2 && cn2.errorCode != 3) {
            cp.a(this.kI);
        }
        if (cn2.errorCode == -1) {
            return;
        }
        boolean bl3 = bl2 = cn2.oc.extras != null ? cn2.oc.extras.getBoolean("_noRefresh", false) : false;
        if (this.kI.kQ.lo) {
            cv.a(cn2.nu);
        } else if (!bl2) {
            if (cn2.mx > 0L) {
                this.kJ.a(cn2.oc, cn2.mx);
            } else if (cn2.pf != null && cn2.pf.mx > 0L) {
                this.kJ.a(cn2.oc, cn2.pf.mx);
            } else if (!cn2.ok && cn2.errorCode == 2) {
                this.kJ.d(cn2.oc);
            }
        }
        if (cn2.errorCode == 3 && cn2.pf != null && cn2.pf.mv != null) {
            da.s("Pinging no fill URLs.");
            bd.a(this.kI.kL, this.kI.kN.pU, cn2, this.kI.adUnitId, false, cn2.pf.mv);
        }
        if (cn2.errorCode != -2) {
            this.a(cn2.errorCode);
            return;
        }
        if (!this.kI.kQ.lo && !this.b(cn2)) {
            this.a(0);
            return;
        }
        if (this.kI.kR != null && this.kI.kR.mP != null) {
            this.kI.kR.mP.a((az)null);
        }
        if (cn2.mP != null) {
            cn2.mP.a(this);
        }
        this.kI.kR = cn2;
        if (cn2.pg != null) {
            this.kI.kQ = cn2.pg;
        }
        this.kI.kS.g(cn2.ph);
        this.kI.kS.h(cn2.pi);
        this.kI.kS.k(this.kI.kQ.lo);
        this.kI.kS.l(cn2.ok);
        if (!this.kI.kQ.lo) {
            this.b(false);
        }
        if (this.kI.kU == null) {
            this.kI.kU = new cr(this.kI.adUnitId);
        }
        int n2 = 0;
        int n3 = 0;
        if (cn2.pf != null) {
            n2 = cn2.pf.my;
            n3 = cn2.pf.mz;
        }
        this.kI.kU.a(n2, n3);
        this.ad();
    }

    public void O() {
        this.af();
    }

    public void R() {
        this.ab();
    }

    public void S() {
        if (this.kI.kQ.lo) {
            this.ag();
        }
        this.aa();
        this.kI.kS.aL();
    }

    public void T() {
        if (this.kI.kQ.lo) {
            this.b(false);
        }
        this.ac();
    }

    public void onAppEvent(String name, String info) {
        if (this.kI.kT != null) {
            try {
                this.kI.kT.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                da.b("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    public void U() {
        this.O();
    }

    public void V() {
        this.S();
    }

    public void W() {
        this.R();
    }

    public void X() {
        this.T();
    }

    public void Y() {
        if (this.kI.kR != null) {
            da.w("Mediation adapter " + this.kI.kR.mO + " refreshed, but mediation adapters should never refresh.");
        }
        this.b(true);
        this.ad();
    }

    public void pause() {
        er.ac("pause must be called on the main UI thread.");
        if (this.kI.kR != null) {
            cv.a(this.kI.kR.nu);
        }
    }

    public void Z() {
        er.ac("recordManualImpression must be called on the main UI thread.");
        if (this.kI.kR == null) {
            da.w("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        da.s("Pinging manual tracking URLs.");
        if (this.kI.kR.om != null) {
            cv.a(this.kI.kL, this.kI.kN.pU, this.kI.kR.om);
        }
    }

    public void resume() {
        er.ac("resume must be called on the main UI thread.");
        if (this.kI.kR != null) {
            cv.b(this.kI.kR.nu);
        }
    }

    public void b(z z2) {
        ViewParent viewParent = this.kI.kK.getParent();
        if (viewParent instanceof View && ((View)viewParent).isShown() && cv.aS()) {
            this.a(z2);
        } else {
            da.u("Ad is not visible. Not refreshing ad.");
            this.kJ.d(z2);
        }
    }

    public void a(af af2) {
        er.ac("setAdListener must be called on the main UI thread.");
        this.kI.kO = af2;
    }

    public void a(ab ab2) {
        er.ac("setAdSize must be called on the main UI thread.");
        this.kI.kQ = ab2;
        if (this.kI.kR != null) {
            this.kI.kR.nu.a(ab2);
        }
        if (this.kI.kK.getChildCount() > 1) {
            this.kI.kK.removeView(this.kI.kK.getNextView());
        }
        this.kI.kK.setMinimumWidth(ab2.widthPixels);
        this.kI.kK.setMinimumHeight(ab2.heightPixels);
        this.kI.kK.requestLayout();
    }

    public void a(ai ai2) {
        er.ac("setAppEventListener must be called on the main UI thread.");
        this.kI.kT = ai2;
    }

    public void showInterstitial() {
        er.ac("showInterstitial must be called on the main UI thread.");
        if (!this.kI.kQ.lo) {
            da.w("Cannot call showInterstitial on a banner ad.");
            return;
        }
        if (this.kI.kR == null) {
            da.w("The interstitial has not loaded.");
            return;
        }
        if (this.kI.kR.nu.be()) {
            da.w("The interstitial is already showing.");
            return;
        }
        this.kI.kR.nu.n(true);
        if (this.kI.kR.ok) {
            try {
                this.kI.kR.mN.showInterstitial();
            }
            catch (RemoteException remoteException) {
                da.b("Could not show interstitial.", remoteException);
                this.ag();
            }
        } else {
            bq bq2 = new bq(this, this, this, this.kI.kR.nu, this.kI.kR.orientation, this.kI.kN);
            bo.a(this.kI.kL, bq2);
        }
    }

    public void stopLoading() {
        er.ac("stopLoading must be called on the main UI thread.");
        if (this.kI.kR != null) {
            this.kI.kR.nu.stopLoading();
            this.kI.kR = null;
        }
        if (this.kI.kP != null) {
            this.kI.kP.cancel();
        }
    }

    private void b(View view) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        this.kI.kK.addView(view, layoutParams);
    }

    private void aa() {
        da.u("Ad closing.");
        if (this.kI.kO != null) {
            try {
                this.kI.kO.onAdClosed();
            }
            catch (RemoteException remoteException) {
                da.b("Could not call AdListener.onAdClosed().", remoteException);
            }
        }
    }

    private void a(int n2) {
        da.w("Failed to load ad: " + n2);
        if (this.kI.kO != null) {
            try {
                this.kI.kO.onAdFailedToLoad(n2);
            }
            catch (RemoteException remoteException) {
                da.b("Could not call AdListener.onAdFailedToLoad().", remoteException);
            }
        }
    }

    private void ab() {
        da.u("Ad leaving application.");
        if (this.kI.kO != null) {
            try {
                this.kI.kO.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                da.b("Could not call AdListener.onAdLeftApplication().", remoteException);
            }
        }
    }

    private void ac() {
        da.u("Ad opening.");
        if (this.kI.kO != null) {
            try {
                this.kI.kO.onAdOpened();
            }
            catch (RemoteException remoteException) {
                da.b("Could not call AdListener.onAdOpened().", remoteException);
            }
        }
    }

    private void ad() {
        da.u("Ad finished loading.");
        if (this.kI.kO != null) {
            try {
                this.kI.kO.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                da.b("Could not call AdListener.onAdLoaded().", remoteException);
            }
        }
    }

    private boolean ae() {
        boolean bl2 = true;
        if (!cv.a(this.kI.kL.getPackageManager(), this.kI.kL.getPackageName(), "android.permission.INTERNET")) {
            if (!this.kI.kQ.lo) {
                cz.a((ViewGroup)this.kI.kK, this.kI.kQ, "Missing internet permission in AndroidManifest.xml.", "Missing internet permission in AndroidManifest.xml. You must have the following declaration: <uses-permission android:name=\"android.permission.INTERNET\" />");
            }
            bl2 = false;
        }
        if (!cv.h(this.kI.kL)) {
            if (!this.kI.kQ.lo) {
                cz.a((ViewGroup)this.kI.kK, this.kI.kQ, "Missing AdActivity with android:configChanges in AndroidManifest.xml.", "Missing AdActivity with android:configChanges in AndroidManifest.xml. You must have the following declaration within the <application> element: <activity android:name=\"com.google.android.gms.ads.AdActivity\" android:configChanges=\"keyboard|keyboardHidden|orientation|screenLayout|uiMode|screenSize|smallestScreenSize\" />");
            }
            bl2 = false;
        }
        if (!bl2 && !this.kI.kQ.lo) {
            this.kI.kK.setVisibility(0);
        }
        return bl2;
    }

    private cd.a c(z z2) {
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.kI.kL.getApplicationInfo();
        try {
            packageManager = this.kI.kL.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = null;
        if (!this.kI.kQ.lo && this.kI.kK.getParent() != null) {
            object = new int[2];
            this.kI.kK.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            DisplayMetrics displayMetrics = this.kI.kL.getResources().getDisplayMetrics();
            int n2 = this.kI.kK.getWidth();
            int n3 = this.kI.kK.getHeight();
            int n4 = 0;
            if (this.kI.kK.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= displayMetrics.widthPixels && object3 <= displayMetrics.heightPixels) {
                n4 = 1;
            }
            packageManager = new Bundle(5);
            packageManager.putInt("x", (int)object2);
            packageManager.putInt("y", (int)object3);
            packageManager.putInt("width", n2);
            packageManager.putInt("height", n3);
            packageManager.putInt("visible", n4);
        }
        object = cp.aP();
        this.kI.kS = new co((String)object, this.kI.adUnitId);
        this.kI.kS.f(z2);
        Bundle bundle = cp.a(this.kI, (String)object, this.kI.kL);
        return new cd.a((Bundle)packageManager, z2, this.kI.kQ, this.kI.adUnitId, applicationInfo, packageInfo, (String)object, cp.pu, this.kI.kN, bundle);
    }

    private void af() {
        if (this.kI.kR == null) {
            da.w("Ad state was null when trying to ping click URLs.");
            return;
        }
        da.s("Pinging click URLs.");
        this.kI.kS.aK();
        if (this.kI.kR.mt != null) {
            cv.a(this.kI.kL, this.kI.kN.pU, this.kI.kR.mt);
        }
        if (this.kI.kR.pf != null && this.kI.kR.pf.mt != null) {
            bd.a(this.kI.kL, this.kI.kN.pU, this.kI.kR, this.kI.adUnitId, false, this.kI.kR.pf.mt);
        }
    }

    private void b(boolean bl2) {
        if (this.kI.kR == null) {
            da.w("Ad state was null when trying to ping impression URLs.");
            return;
        }
        da.s("Pinging Impression URLs.");
        this.kI.kS.aJ();
        if (this.kI.kR.mu != null) {
            cv.a(this.kI.kL, this.kI.kN.pU, this.kI.kR.mu);
        }
        if (this.kI.kR.pf != null && this.kI.kR.pf.mu != null) {
            bd.a(this.kI.kL, this.kI.kN.pU, this.kI.kR, this.kI.adUnitId, bl2, this.kI.kR.pf.mu);
        }
        if (this.kI.kR.mM != null && this.kI.kR.mM.mp != null) {
            bd.a(this.kI.kL, this.kI.kN.pU, this.kI.kR, this.kI.adUnitId, bl2, this.kI.kR.mM.mp);
        }
    }

    private void ag() {
        if (this.kI.kR != null) {
            this.kI.kR.nu.destroy();
            this.kI.kR = null;
        }
    }

    private boolean b(cn cn2) {
        View view;
        if (cn2.ok) {
            try {
                view = (View)c.b(cn2.mN.getView());
            }
            catch (RemoteException remoteException) {
                da.b("Could not get View from mediation adapter.", remoteException);
                return false;
            }
            View view2 = this.kI.kK.getNextView();
            if (view2 != null) {
                this.kI.kK.removeView(view2);
            }
            try {
                this.b(view);
            }
            catch (Throwable throwable) {
                da.b("Could not add mediation view to view hierarchy.", throwable);
                return false;
            }
        }
        if (cn2.pg != null) {
            cn2.nu.a(cn2.pg);
            this.kI.kK.removeAllViews();
            this.kI.kK.setMinimumWidth(cn2.pg.widthPixels);
            this.kI.kK.setMinimumHeight(cn2.pg.heightPixels);
            this.b((View)cn2.nu);
        }
        if (this.kI.kK.getChildCount() > 1) {
            this.kI.kK.showNext();
        }
        if (this.kI.kR != null) {
            view = this.kI.kK.getNextView();
            if (view instanceof dd) {
                ((dd)view).a(this.kI.kL, this.kI.kQ);
            } else if (view != null) {
                this.kI.kK.removeView(view);
            }
            if (this.kI.kR.mN != null) {
                try {
                    this.kI.kR.mN.destroy();
                }
                catch (RemoteException remoteException) {
                    da.w("Could not destroy previous mediation adapter.");
                }
            }
        }
        this.kI.kK.setVisibility(0);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class a {
        public final ViewSwitcher kK;
        public final String adUnitId;
        public final Context kL;
        public final l kM;
        public final db kN;
        public af kO;
        public ct kP;
        public ab kQ;
        public cn kR;
        public co kS;
        public ai kT;
        public cr kU = null;
        private HashSet<co> kV = null;

        public a(Context context, ab ab2, String string2, db db2) {
            if (ab2.lo) {
                this.kK = null;
            } else {
                this.kK = new ViewSwitcher(context);
                this.kK.setMinimumWidth(ab2.widthPixels);
                this.kK.setMinimumHeight(ab2.heightPixels);
                this.kK.setVisibility(4);
            }
            this.kQ = ab2;
            this.adUnitId = string2;
            this.kL = context;
            this.kM = new l(k.a(db2.pU, context));
            this.kN = db2;
        }

        public void a(HashSet<co> hashSet) {
            this.kV = hashSet;
        }

        public HashSet<co> ah() {
            return this.kV;
        }
    }
}

