/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int wj;
    private final List<LatLng> Qo;
    private final List<List<LatLng>> Qp;
    private float PM = 10.0f;
    private int PN = -16777216;
    private int PO = 0;
    private float PP = 0.0f;
    private boolean PQ = true;
    private boolean Qq = false;

    public PolygonOptions() {
        this.wj = 1;
        this.Qo = new ArrayList<LatLng>();
        this.Qp = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.wj = versionCode;
        this.Qo = points;
        this.Qp = holes;
        this.PM = strokeWidth;
        this.PN = strokeColor;
        this.PO = fillColor;
        this.PP = zIndex;
        this.PQ = visible;
        this.Qq = geodesic;
    }

    int getVersionCode() {
        return this.wj;
    }

    List hg() {
        return this.Qp;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.hc()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.Qo.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.Qo.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.Qo.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.Qp.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.PM = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.PN = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.PO = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.PP = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.PQ = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.Qq = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.Qo;
    }

    public List<List<LatLng>> getHoles() {
        return this.Qp;
    }

    public float getStrokeWidth() {
        return this.PM;
    }

    public int getStrokeColor() {
        return this.PN;
    }

    public int getFillColor() {
        return this.PO;
    }

    public float getZIndex() {
        return this.PP;
    }

    public boolean isVisible() {
        return this.PQ;
    }

    public boolean isGeodesic() {
        return this.Qq;
    }
}

