/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptionsCreator;
import com.google.android.gms.maps.model.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolylineOptions
implements SafeParcelable {
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    private final int wj;
    private final List<LatLng> Qo;
    private float PU = 10.0f;
    private int yX = -16777216;
    private float PP = 0.0f;
    private boolean PQ = true;
    private boolean Qq = false;

    public PolylineOptions() {
        this.wj = 1;
        this.Qo = new ArrayList<LatLng>();
    }

    PolylineOptions(int versionCode, List points, float width, int color, float zIndex, boolean visible, boolean geodesic) {
        this.wj = versionCode;
        this.Qo = points;
        this.PU = width;
        this.yX = color;
        this.PP = zIndex;
        this.PQ = visible;
        this.Qq = geodesic;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.hc()) {
            h.a(this, out, flags);
        } else {
            PolylineOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    int getVersionCode() {
        return this.wj;
    }

    public PolylineOptions add(LatLng point) {
        this.Qo.add(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        this.Qo.addAll(Arrays.asList(points));
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.Qo.add(latLng);
        }
        return this;
    }

    public PolylineOptions width(float width) {
        this.PU = width;
        return this;
    }

    public PolylineOptions color(int color) {
        this.yX = color;
        return this;
    }

    public PolylineOptions zIndex(float zIndex) {
        this.PP = zIndex;
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.PQ = visible;
        return this;
    }

    public PolylineOptions geodesic(boolean geodesic) {
        this.Qq = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.Qo;
    }

    public float getWidth() {
        return this.PU;
    }

    public int getColor() {
        return this.yX;
    }

    public float getZIndex() {
        return this.PP;
    }

    public boolean isVisible() {
        return this.PQ;
    }

    public boolean isGeodesic() {
        return this.Qq;
    }
}

