/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.c;
import com.google.android.gms.internal.jd;
import com.google.android.gms.internal.kd;
import com.google.android.gms.internal.ke;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class cq
implements o.f {
    private final Context mContext;
    private final String TM;
    private final ExecutorService Wp;
    private bg<jd.a> Wi;

    cq(Context context, String string) {
        this.mContext = context;
        this.TM = string;
        this.Wp = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<jd.a> bg2) {
        this.Wi = bg2;
    }

    @Override
    public void iN() {
        this.Wp.execute(new Runnable(){

            public void run() {
                cq.this.jC();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jC() {
        if (this.Wi == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.Wi.iM();
        bh.v("Start loading resource from disk ...");
        if ((ce.ju().jv() == ce.a.VX || ce.ju().jv() == ce.a.VY) && this.TM.equals(ce.ju().getContainerId())) {
            this.Wi.a(bg.a.VA);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.jD());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.s("resource not on disk");
            this.Wi.a(bg.a.VA);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(fileInputStream, byteArrayOutputStream);
            this.Wi.i(jd.a.l(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            bh.w("error reading resource from disk");
            this.Wi.a(bg.a.VB);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.w("error closing stream for reading resource from disk");
            }
        }
        bh.v("Load resource from disk finished.");
    }

    @Override
    public void b(final jd.a a2) {
        this.Wp.execute(new Runnable(){

            public void run() {
                cq.this.c(a2);
            }
        });
    }

    @Override
    public cr.c bP(int n2) {
        bh.v("Atttempting to load container from resource ID " + n2);
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(inputStream, byteArrayOutputStream);
            cr.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                return c2;
            }
            return this.k(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.w("Error reading default container resource with ID " + n2);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.w("No default container resource found.");
            return null;
        }
    }

    private cr.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return ba.br(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.s("Tried to convert binary resource to string for JSON parsing; not UTF-8 format");
            return null;
        }
        catch (JSONException jSONException) {
            bh.w("Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cr.c k(byte[] byArray) {
        try {
            return cr.b(c.f.a(byArray));
        }
        catch (kd kd2) {
            bh.w("Resource doesn't contain a binary container");
            return null;
        }
        catch (cr.g g2) {
            bh.w("Resource doesn't contain a binary container");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.Wp.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(jd.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.jD();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.t("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(ke.d(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.w("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.w("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File jD() {
        String string = "resource_" + this.TM;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }
}

