/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.jg;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;

public final class Wallet {
    static final Api.b<jg> va = new Api.b<jg>(){

        public jg i(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            er.b(context instanceof Activity, (Object)"An Activity must be used for Wallet APIs");
            Activity activity = (Activity)context;
            er.b(apiOptions == null || apiOptions instanceof WalletOptions, (Object)"WalletOptions must be used for Wallet APIs");
            WalletOptions walletOptions = apiOptions != null ? (WalletOptions)apiOptions : new WalletOptions();
            return new jg(activity, looper, connectionCallbacks, onConnectionFailedListener, walletOptions.environment, ee2.getAccountName(), walletOptions.theme);
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.i(context, looper, ee2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api API = new Api(va, new Scope[0]);

    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, final int requestCode) {
        googleApiClient.a(new a(){

            protected void a(jg jg2) {
                jg2.checkForPreAuthorization(requestCode);
                this.a(Status.zQ);
            }
        });
    }

    public static void loadMaskedWallet(GoogleApiClient googleApiClient, final MaskedWalletRequest request, final int requestCode) {
        googleApiClient.a(new a(){

            protected void a(jg jg2) {
                jg2.loadMaskedWallet(request, requestCode);
                this.a(Status.zQ);
            }
        });
    }

    public static void loadFullWallet(GoogleApiClient googleApiClient, final FullWalletRequest request, final int requestCode) {
        googleApiClient.a(new a(){

            protected void a(jg jg2) {
                jg2.loadFullWallet(request, requestCode);
                this.a(Status.zQ);
            }
        });
    }

    public static void changeMaskedWallet(GoogleApiClient googleApiClient, final String googleTransactionId, final String merchantTransactionId, final int requestCode) {
        googleApiClient.a(new a(){

            protected void a(jg jg2) {
                jg2.changeMaskedWallet(googleTransactionId, merchantTransactionId, requestCode);
                this.a(Status.zQ);
            }
        });
    }

    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, final NotifyTransactionStatusRequest request) {
        googleApiClient.a(new a(){

            protected void a(jg jg2) {
                jg2.notifyTransactionStatus(request);
                this.a(Status.zQ);
            }
        });
    }

    private Wallet() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class a
    extends a.a<Status, jg> {
        public a() {
            super(va);
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    public static final class WalletOptions
    implements GoogleApiClient.ApiOptions {
        public final int environment;
        public final int theme;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.Zw;
            this.theme = builder.mTheme;
        }

        public static final class Builder {
            private int Zw = 0;
            private int mTheme = 0;

            public Builder setEnvironment(int environment) {
                if (environment != 0 && environment != 2 && environment != 1) {
                    String string2 = String.format("Invalid environment value %d", environment);
                    throw new IllegalArgumentException(string2);
                }
                this.Zw = environment;
                return this;
            }

            public Builder setTheme(int theme) {
                if (theme != 0 && theme != 1) {
                    String string2 = String.format("Invalid theme value %d", theme);
                    throw new IllegalArgumentException(string2);
                }
                this.mTheme = theme;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

