package com.websmithing.gpstracker2.di;

import android.content.Context;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.websmithing.gpstracker2.data.repository.LocationRepository;
import com.websmithing.gpstracker2.data.repository.SettingsRepository;
import com.websmithing.gpstracker2.util.PermissionChecker;
import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

@ScopeMetadata("javax.inject.Singleton")
@QualifierMetadata("dagger.hilt.android.qualifiers.ApplicationContext")
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class RepositoryModule_ProvideLocationRepositoryFactory implements Factory<LocationRepository> {
  private final Provider<Context> contextProvider;

  private final Provider<FusedLocationProviderClient> fusedLocationProviderClientProvider;

  private final Provider<OkHttpClient> okHttpClientProvider;

  private final Provider<Retrofit.Builder> retrofitBuilderProvider;

  private final Provider<SettingsRepository> settingsRepositoryProvider;

  private final Provider<PermissionChecker> permissionCheckerProvider;

  public RepositoryModule_ProvideLocationRepositoryFactory(Provider<Context> contextProvider,
      Provider<FusedLocationProviderClient> fusedLocationProviderClientProvider,
      Provider<OkHttpClient> okHttpClientProvider,
      Provider<Retrofit.Builder> retrofitBuilderProvider,
      Provider<SettingsRepository> settingsRepositoryProvider,
      Provider<PermissionChecker> permissionCheckerProvider) {
    this.contextProvider = contextProvider;
    this.fusedLocationProviderClientProvider = fusedLocationProviderClientProvider;
    this.okHttpClientProvider = okHttpClientProvider;
    this.retrofitBuilderProvider = retrofitBuilderProvider;
    this.settingsRepositoryProvider = settingsRepositoryProvider;
    this.permissionCheckerProvider = permissionCheckerProvider;
  }

  @Override
  public LocationRepository get() {
    return provideLocationRepository(contextProvider.get(), fusedLocationProviderClientProvider.get(), okHttpClientProvider.get(), retrofitBuilderProvider.get(), settingsRepositoryProvider.get(), permissionCheckerProvider.get());
  }

  public static RepositoryModule_ProvideLocationRepositoryFactory create(
      Provider<Context> contextProvider,
      Provider<FusedLocationProviderClient> fusedLocationProviderClientProvider,
      Provider<OkHttpClient> okHttpClientProvider,
      Provider<Retrofit.Builder> retrofitBuilderProvider,
      Provider<SettingsRepository> settingsRepositoryProvider,
      Provider<PermissionChecker> permissionCheckerProvider) {
    return new RepositoryModule_ProvideLocationRepositoryFactory(contextProvider, fusedLocationProviderClientProvider, okHttpClientProvider, retrofitBuilderProvider, settingsRepositoryProvider, permissionCheckerProvider);
  }

  public static LocationRepository provideLocationRepository(Context context,
      FusedLocationProviderClient fusedLocationProviderClient, OkHttpClient okHttpClient,
      Retrofit.Builder retrofitBuilder, SettingsRepository settingsRepository,
      PermissionChecker permissionChecker) {
    return Preconditions.checkNotNullFromProvides(RepositoryModule.INSTANCE.provideLocationRepository(context, fusedLocationProviderClient, okHttpClient, retrofitBuilder, settingsRepository, permissionChecker));
  }
}
