package com.websmithing.gpstracker2.data.repository;

import android.location.Location;
import kotlinx.coroutines.flow.Flow;

/**
 * Repository interface for handling location fetching, state, uploading, and observing updates.
 */
@kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\r\u001a\u0004\u0018\u00010\bH\u00a6@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bH\u00a6@\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0010\u001a\u00020\u0011H\u00a6@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bH\u00a6@\u00a2\u0006\u0002\u0010\u0014J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u00a6@\u00a2\u0006\u0002\u0010\u001cR\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001d"}, d2 = {"Lcom/websmithing/gpstracker2/data/repository/LocationRepository;", "", "lastUploadStatus", "Lkotlinx/coroutines/flow/Flow;", "Lcom/websmithing/gpstracker2/data/repository/UploadStatus;", "getLastUploadStatus", "()Lkotlinx/coroutines/flow/Flow;", "latestLocation", "Landroid/location/Location;", "getLatestLocation", "totalDistance", "", "getTotalDistance", "getCurrentLocation", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPreviousLocation", "resetLocationState", "", "saveAsPreviousLocation", "location", "(Landroid/location/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadLocationData", "", "username", "", "appId", "sessionId", "eventType", "(Landroid/location/Location;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app_debug"})
public abstract interface LocationRepository {
    
    /**
     * A flow emitting the latest known device location.
     * Emits null if no location has been received yet.
     */
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<android.location.Location> getLatestLocation();
    
    /**
     * A flow emitting the total distance traveled in meters since tracking started.
     */
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<java.lang.Float> getTotalDistance();
    
    /**
     * A flow emitting the status of the last location upload attempt.
     */
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<com.websmithing.gpstracker2.data.repository.UploadStatus> getLastUploadStatus();
    
    /**
     * Fetches the current device location.
     * Throws SecurityException if permissions are missing.
     * Returns null if location could not be determined.
     */
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getCurrentLocation(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super android.location.Location> $completion);
    
    /**
     * Uploads the provided location data to the backend.
     * Handles data preparation (formatting, encoding).
     * Returns true on successful upload acknowledged by the server, false otherwise.
     */
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object uploadLocationData(@org.jetbrains.annotations.NotNull()
    android.location.Location location, @org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    java.lang.String appId, @org.jetbrains.annotations.NotNull()
    java.lang.String sessionId, @org.jetbrains.annotations.NotNull()
    java.lang.String eventType, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> $completion);
    
    /**
     * Retrieves the previously saved location point.
     * Returns null if no previous location is stored.
     */
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getPreviousLocation(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super android.location.Location> $completion);
    
    /**
     * Saves the current location as the "previous" location for the next calculation.
     */
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object saveAsPreviousLocation(@org.jetbrains.annotations.NotNull()
    android.location.Location location, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    /**
     * Resets the location state, typically called when a new tracking session starts.
     * This should clear the previous location and reset the total distance.
     */
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object resetLocationState(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
}