package com.websmithing.gpstracker2.data.repository;

import kotlinx.coroutines.flow.Flow;

/**
 * Repository interface for managing user settings and tracking state.
 */
@kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\u00020\u0003H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\nH\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\fH\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u0010H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H&J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H&J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H&J\u000e\u0010\u0015\u001a\u00020\fH\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\fH\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H&J\u000e\u0010\u0018\u001a\u00020\u0003H\u00a6@\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\fH\u00a6@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\nH\u00a6@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0006H\u00a6@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010\'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\fH\u00a6@\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\fH\u00a6@\u00a2\u0006\u0002\u0010)\u00a8\u0006+"}, d2 = {"Lcom/websmithing/gpstracker2/data/repository/SettingsRepository;", "", "clearSessionId", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateAndSaveAppId", "", "getAppId", "getCurrentSessionId", "getCurrentTrackingInterval", "", "getCurrentTrackingState", "", "getCurrentUsername", "getCurrentWebsiteUrl", "getTotalDistance", "", "getTrackingInterval", "Lkotlinx/coroutines/flow/Flow;", "getUsername", "getWebsiteUrl", "isFirstTimeGettingPosition", "isFirstTimeLoading", "isTracking", "resetLocationStateForNewSession", "saveDistanceAndPositionFlags", "totalDistance", "firstTime", "(FZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveSessionId", "sessionId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveTrackingInterval", "intervalMinutes", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveUsername", "username", "saveWebsiteUrl", "url", "setFirstTimeLoading", "isFirst", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setTrackingState", "app_debug"})
public abstract interface SettingsRepository {
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object setTrackingState(boolean isTracking, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<java.lang.Boolean> isTracking();
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getCurrentTrackingState(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object saveUsername(@org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<java.lang.String> getUsername();
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getCurrentUsername(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object saveTrackingInterval(int intervalMinutes, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<java.lang.Integer> getTrackingInterval();
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getCurrentTrackingInterval(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object saveWebsiteUrl(@org.jetbrains.annotations.NotNull()
    java.lang.String url, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.NotNull()
    public abstract kotlinx.coroutines.flow.Flow<java.lang.String> getWebsiteUrl();
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getCurrentWebsiteUrl(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object saveSessionId(@org.jetbrains.annotations.NotNull()
    java.lang.String sessionId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object clearSessionId(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getCurrentSessionId(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getAppId(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object isFirstTimeLoading(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object setFirstTimeLoading(boolean isFirst, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object generateAndSaveAppId(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object resetLocationStateForNewSession(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object saveDistanceAndPositionFlags(float totalDistance, boolean firstTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getTotalDistance(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Float> $completion);
    
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object isFirstTimeGettingPosition(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> $completion);
}