package com.websmithing.gpstracker2.di;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.websmithing.gpstracker2.data.repository.LocationRepository;
import com.websmithing.gpstracker2.data.repository.LocationRepositoryImpl;
import com.websmithing.gpstracker2.data.repository.SettingsRepository;
import com.websmithing.gpstracker2.data.repository.SettingsRepositoryImpl;
import com.websmithing.gpstracker2.util.PermissionChecker;
import com.websmithing.gpstracker2.util.PermissionCheckerImpl;
import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import dagger.hilt.InstallIn;
import dagger.hilt.android.qualifiers.ApplicationContext;
import dagger.hilt.components.SingletonComponent;
import javax.inject.Singleton;

@dagger.Module()
@kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2 = {"Lcom/websmithing/gpstracker2/di/RepositoryModule;", "", "()V", "provideLocationRepository", "Lcom/websmithing/gpstracker2/data/repository/LocationRepository;", "context", "Landroid/content/Context;", "fusedLocationProviderClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "okHttpClient", "Lokhttp3/OkHttpClient;", "retrofitBuilder", "Lretrofit2/Retrofit$Builder;", "settingsRepository", "Lcom/websmithing/gpstracker2/data/repository/SettingsRepository;", "permissionChecker", "Lcom/websmithing/gpstracker2/util/PermissionChecker;", "provideSettingsRepository", "sharedPreferences", "Landroid/content/SharedPreferences;", "app_debug"})
@dagger.hilt.InstallIn(value = {dagger.hilt.components.SingletonComponent.class})
public final class RepositoryModule {
    @org.jetbrains.annotations.NotNull()
    public static final com.websmithing.gpstracker2.di.RepositoryModule INSTANCE = null;
    
    private RepositoryModule() {
        super();
    }
    
    @dagger.Provides()
    @javax.inject.Singleton()
    @org.jetbrains.annotations.NotNull()
    public final com.websmithing.gpstracker2.data.repository.SettingsRepository provideSettingsRepository(@org.jetbrains.annotations.NotNull()
    android.content.SharedPreferences sharedPreferences) {
        return null;
    }
    
    @dagger.Provides()
    @javax.inject.Singleton()
    @org.jetbrains.annotations.NotNull()
    public final com.websmithing.gpstracker2.data.repository.LocationRepository provideLocationRepository(@dagger.hilt.android.qualifiers.ApplicationContext()
    @org.jetbrains.annotations.NotNull()
    android.content.Context context, @org.jetbrains.annotations.NotNull()
    com.google.android.gms.location.FusedLocationProviderClient fusedLocationProviderClient, @org.jetbrains.annotations.NotNull()
    okhttp3.OkHttpClient okHttpClient, @org.jetbrains.annotations.NotNull()
    retrofit2.Retrofit.Builder retrofitBuilder, @org.jetbrains.annotations.NotNull()
    com.websmithing.gpstracker2.data.repository.SettingsRepository settingsRepository, @org.jetbrains.annotations.NotNull()
    com.websmithing.gpstracker2.util.PermissionChecker permissionChecker) {
        return null;
    }
}