package com.websmithing.gpstracker2.network;

import retrofit2.Response;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

/**
 * Retrofit API interface for the GPS Tracker backend.
 */
@kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001J\u0096\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0003\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\b2\b\b\u0003\u0010\n\u001a\u00020\u00042\b\b\u0003\u0010\u000b\u001a\u00020\u00042\b\b\u0003\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\r\u001a\u00020\u00042\b\b\u0003\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u000f\u001a\u00020\u00042\b\b\u0003\u0010\u0010\u001a\u00020\b2\b\b\u0003\u0010\u0011\u001a\u00020\u00042\b\b\u0003\u0010\u0012\u001a\u00020\u0004H\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u008c\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\u0010\u001a\u00020\b2\b\b\u0001\u0010\u0011\u001a\u00020\u00042\b\b\u0001\u0010\u0012\u001a\u00020\u0004H\u00a7@\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2 = {"Lcom/websmithing/gpstracker2/network/ApiService;", "", "testUpdate", "Lretrofit2/Response;", "", "latitude", "longitude", "speed", "", "direction", "distance", "date", "locationMethod", "username", "phoneNumber", "sessionId", "accuracy", "extraInfo", "eventType", "(Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateLocation", "(Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app_debug"})
public abstract interface ApiService {
    
    /**
     * Sends location data to the server.
     * Corresponds to: https://www.websmithing.com/gpstracker/api/locations/update
     * Content-Type: application/x-www-form-urlencoded
     *
     * @return A Response containing a String. Success should be the DB ID/timestamp, failure is "-1".
     */
    @retrofit2.http.FormUrlEncoded()
    @retrofit2.http.POST(value = "update")
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object updateLocation(@retrofit2.http.Field(value = "latitude")
    @org.jetbrains.annotations.NotNull()
    java.lang.String latitude, @retrofit2.http.Field(value = "longitude")
    @org.jetbrains.annotations.NotNull()
    java.lang.String longitude, @retrofit2.http.Field(value = "speed")
    int speed, @retrofit2.http.Field(value = "direction")
    int direction, @retrofit2.http.Field(value = "date")
    @org.jetbrains.annotations.NotNull()
    java.lang.String date, @retrofit2.http.Field(value = "locationmethod")
    @org.jetbrains.annotations.NotNull()
    java.lang.String locationMethod, @retrofit2.http.Field(value = "username")
    @org.jetbrains.annotations.NotNull()
    java.lang.String username, @retrofit2.http.Field(value = "phonenumber")
    @org.jetbrains.annotations.NotNull()
    java.lang.String phoneNumber, @retrofit2.http.Field(value = "sessionid")
    @org.jetbrains.annotations.NotNull()
    java.lang.String sessionId, @retrofit2.http.Field(value = "accuracy")
    int accuracy, @retrofit2.http.Field(value = "extrainfo")
    @org.jetbrains.annotations.NotNull()
    java.lang.String extraInfo, @retrofit2.http.Field(value = "eventtype")
    @org.jetbrains.annotations.NotNull()
    java.lang.String eventType, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super retrofit2.Response<java.lang.String>> $completion);
    
    /**
     * Simple test method with minimal parameters for debugging
     */
    @retrofit2.http.FormUrlEncoded()
    @retrofit2.http.POST(value = "update")
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object testUpdate(@retrofit2.http.Field(value = "latitude")
    @org.jetbrains.annotations.NotNull()
    java.lang.String latitude, @retrofit2.http.Field(value = "longitude")
    @org.jetbrains.annotations.NotNull()
    java.lang.String longitude, @retrofit2.http.Field(value = "speed")
    int speed, @retrofit2.http.Field(value = "direction")
    int direction, @retrofit2.http.Field(value = "distance")
    @org.jetbrains.annotations.NotNull()
    java.lang.String distance, @retrofit2.http.Field(value = "date")
    @org.jetbrains.annotations.NotNull()
    java.lang.String date, @retrofit2.http.Field(value = "locationmethod")
    @org.jetbrains.annotations.NotNull()
    java.lang.String locationMethod, @retrofit2.http.Field(value = "username")
    @org.jetbrains.annotations.NotNull()
    java.lang.String username, @retrofit2.http.Field(value = "phonenumber")
    @org.jetbrains.annotations.NotNull()
    java.lang.String phoneNumber, @retrofit2.http.Field(value = "sessionid")
    @org.jetbrains.annotations.NotNull()
    java.lang.String sessionId, @retrofit2.http.Field(value = "accuracy")
    int accuracy, @retrofit2.http.Field(value = "extrainfo")
    @org.jetbrains.annotations.NotNull()
    java.lang.String extraInfo, @retrofit2.http.Field(value = "eventtype")
    @org.jetbrains.annotations.NotNull()
    java.lang.String eventType, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super retrofit2.Response<java.lang.String>> $completion);
    
    /**
     * Retrofit API interface for the GPS Tracker backend.
     */
    @kotlin.Metadata(mv = {1, 9, 0}, k = 3, xi = 48)
    public static final class DefaultImpls {
    }
}