package com.websmithing.gpstracker2.ui;

import android.content.Context;
import android.content.Intent;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.websmithing.gpstracker2.data.repository.LocationRepository;
import com.websmithing.gpstracker2.data.repository.SettingsRepository;
import com.websmithing.gpstracker2.data.repository.UploadStatus;
import com.websmithing.gpstracker2.service.TrackingService;
import dagger.hilt.android.lifecycle.HiltViewModel;
import dagger.hilt.android.qualifiers.ApplicationContext;
import android.location.Location;
import kotlinx.coroutines.flow.*;
import timber.log.Timber;
import java.util.*;
import javax.inject.Inject;

@kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B!\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000fJ\u0006\u00100\u001a\u00020-J\u000e\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\rJ\u000e\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\rJ\u0006\u00105\u001a\u00020-J\u0006\u00106\u001a\u00020-J\u0010\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u000bH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001dR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\'\u0010\u0018R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0018\u00a8\u0006:"}, d2 = {"Lcom/websmithing/gpstracker2/ui/TrackingViewModel;", "Landroidx/lifecycle/ViewModel;", "context", "Landroid/content/Context;", "settingsRepository", "Lcom/websmithing/gpstracker2/data/repository/SettingsRepository;", "locationRepository", "Lcom/websmithing/gpstracker2/data/repository/LocationRepository;", "(Landroid/content/Context;Lcom/websmithing/gpstracker2/data/repository/SettingsRepository;Lcom/websmithing/gpstracker2/data/repository/LocationRepository;)V", "_isTracking", "Landroidx/lifecycle/MutableLiveData;", "", "_snackbarMessage", "", "_trackingInterval", "", "_userName", "_websiteUrl", "initJob", "Lkotlinx/coroutines/Job;", "getInitJob$app_debug", "()Lkotlinx/coroutines/Job;", "isTracking", "Landroidx/lifecycle/LiveData;", "()Landroidx/lifecycle/LiveData;", "lastUploadStatus", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/websmithing/gpstracker2/data/repository/UploadStatus;", "getLastUploadStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "latestLocation", "Landroid/location/Location;", "getLatestLocation", "snackbarMessage", "getSnackbarMessage", "totalDistance", "", "getTotalDistance", "trackingInterval", "getTrackingInterval", "userName", "getUserName", "websiteUrl", "getWebsiteUrl", "forceStopTracking", "", "onIntervalChanged", "newInterval", "onSnackbarMessageShown", "onUserNameChanged", "newName", "onWebsiteUrlChanged", "newUrl", "startTracking", "stopTracking", "updateTrackingState", "shouldTrack", "Companion", "app_debug"})
@dagger.hilt.android.lifecycle.HiltViewModel()
public final class TrackingViewModel extends androidx.lifecycle.ViewModel {
    @org.jetbrains.annotations.NotNull()
    private final android.content.Context context = null;
    @org.jetbrains.annotations.NotNull()
    private final com.websmithing.gpstracker2.data.repository.SettingsRepository settingsRepository = null;
    @org.jetbrains.annotations.NotNull()
    private final com.websmithing.gpstracker2.data.repository.LocationRepository locationRepository = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.MutableLiveData<java.lang.Boolean> _isTracking = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.LiveData<java.lang.Boolean> isTracking = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.MutableLiveData<java.lang.String> _userName = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.LiveData<java.lang.String> userName = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.MutableLiveData<java.lang.Integer> _trackingInterval = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.LiveData<java.lang.Integer> trackingInterval = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.MutableLiveData<java.lang.String> _websiteUrl = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.LiveData<java.lang.String> websiteUrl = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.MutableLiveData<java.lang.String> _snackbarMessage = null;
    @org.jetbrains.annotations.NotNull()
    private final androidx.lifecycle.LiveData<java.lang.String> snackbarMessage = null;
    @org.jetbrains.annotations.NotNull()
    private final kotlinx.coroutines.flow.StateFlow<android.location.Location> latestLocation = null;
    @org.jetbrains.annotations.NotNull()
    private final kotlinx.coroutines.flow.StateFlow<java.lang.Float> totalDistance = null;
    @org.jetbrains.annotations.NotNull()
    private final kotlinx.coroutines.flow.StateFlow<com.websmithing.gpstracker2.data.repository.UploadStatus> lastUploadStatus = null;
    @org.jetbrains.annotations.NotNull()
    private final kotlinx.coroutines.Job initJob = null;
    @org.jetbrains.annotations.NotNull()
    private static final java.lang.String TAG = "TrackingViewModel";
    @org.jetbrains.annotations.NotNull()
    public static final com.websmithing.gpstracker2.ui.TrackingViewModel.Companion Companion = null;
    
    @javax.inject.Inject()
    public TrackingViewModel(@dagger.hilt.android.qualifiers.ApplicationContext()
    @org.jetbrains.annotations.NotNull()
    android.content.Context context, @org.jetbrains.annotations.NotNull()
    com.websmithing.gpstracker2.data.repository.SettingsRepository settingsRepository, @org.jetbrains.annotations.NotNull()
    com.websmithing.gpstracker2.data.repository.LocationRepository locationRepository) {
        super();
    }
    
    @org.jetbrains.annotations.NotNull()
    public final androidx.lifecycle.LiveData<java.lang.Boolean> isTracking() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final androidx.lifecycle.LiveData<java.lang.String> getUserName() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final androidx.lifecycle.LiveData<java.lang.Integer> getTrackingInterval() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final androidx.lifecycle.LiveData<java.lang.String> getWebsiteUrl() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final androidx.lifecycle.LiveData<java.lang.String> getSnackbarMessage() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final kotlinx.coroutines.flow.StateFlow<android.location.Location> getLatestLocation() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final kotlinx.coroutines.flow.StateFlow<java.lang.Float> getTotalDistance() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final kotlinx.coroutines.flow.StateFlow<com.websmithing.gpstracker2.data.repository.UploadStatus> getLastUploadStatus() {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final kotlinx.coroutines.Job getInitJob$app_debug() {
        return null;
    }
    
    public final void startTracking() {
    }
    
    public final void stopTracking() {
    }
    
    public final void forceStopTracking() {
    }
    
    public final void onIntervalChanged(int newInterval) {
    }
    
    public final void onUserNameChanged(@org.jetbrains.annotations.NotNull()
    java.lang.String newName) {
    }
    
    public final void onWebsiteUrlChanged(@org.jetbrains.annotations.NotNull()
    java.lang.String newUrl) {
    }
    
    public final void onSnackbarMessageShown() {
    }
    
    private final kotlinx.coroutines.Job updateTrackingState(boolean shouldTrack) {
        return null;
    }
    
    @kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/websmithing/gpstracker2/ui/TrackingViewModel$Companion;", "", "()V", "TAG", "", "app_debug"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}