package com.websmithing.gpstracker2.util;

/**
 * Interface for checking app permissions. Allows for easier testing by mocking.
 */
@kotlin.Metadata(mv = {1, 9, 0}, k = 1, xi = 48, d1 = {"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2 = {"Lcom/websmithing/gpstracker2/util/PermissionChecker;", "", "hasLocationPermission", "", "app_debug"})
public abstract interface PermissionChecker {
    
    /**
     * Checks if either ACCESS_FINE_LOCATION or ACCESS_COARSE_LOCATION permission is granted.
     * @return true if location permission is granted, false otherwise.
     */
    public abstract boolean hasLocationPermission();
}