<?php
session_start();
include '../../Conexion/conexion.php';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <title>Login</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitizar y validar la cédula
    $cedula = trim($_POST['cedula']);
    $password = $_POST['password'];

    if (!preg_match('/^[0-9]{8,15}$/', $cedula)) {
        echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Formato de cédula inválido. La cédula debe tener entre 8 y 15 dígitos.'
                }).then(() => {
                    window.location.href = 'login.php';
                });
              </script>";
        exit();
    }

    // Obtener el id_user a partir de la cédula
    $sql = "SELECT id_user, password FROM user WHERE cedula = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Error en la preparación de la consulta'
                }).then(() => {
                    window.location.href = 'login.php';
                });
              </script>";
        exit();
    }

    $stmt->bind_param("s", $cedula);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        // Verificar la contraseña
        if (password_verify($password, $row['password'])) {
            $user_id = $row['id_user'];

            // Actualizar el campo 'ultimo_login' en la tabla 'user' con la fecha y hora actual
            $update_sql = "UPDATE user SET ultimo_login = NOW() WHERE id_user = ?";
            $update_stmt = $conn->prepare($update_sql);
            if ($update_stmt === false) {
                echo "<script>
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Error en la actualización de ultimo_login'
                        }).then(() => {
                            window.location.href = 'login.php';
                        });
                      </script>";
                exit();
            }
            $update_stmt->bind_param("i", $user_id);
            $update_stmt->execute();

            // Obtener el rol del usuario desde la tabla rol_user
            $sql = "SELECT id_rol FROM rol_user WHERE id_user = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt === false) {
                echo "<script>
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Error en la preparación de la consulta del rol'
                        }).then(() => {
                            window.location.href = 'login.php';
                        });
                      </script>";
                exit();
            }
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $role_row = $result->fetch_assoc();
                $role_id = $role_row['id_rol'];

                // Guardar en la sesión
                $_SESSION['user_id'] = $user_id;  
                $_SESSION['role_id'] = $role_id;

                // Redirigir según el rol del usuario
                echo "<script>
                        Swal.fire({
                            icon: 'success',
                            title: 'Bienvenido',
                            text: 'Inicio de sesión exitoso',
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = '";
                            switch ($role_id) {
                                case 1:
                                    echo '../dashboard.php';
                                    break;
                                case 2:
                                    echo '../dashboard2.php';
                                    break;
                                case 3:
                                    echo 'inicio.php';
                                    break;
                                default:
                                    echo 'login.php';
                                    break;
                            }
                        echo "';
                        });
                      </script>";
                exit();
            } else {
                echo "<script>
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Rol no encontrado en rol_user'
                        }).then(() => {
                            window.location.href = 'login.php';
                        });
                      </script>";
            }
        } else {
            echo "<script>
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Verifica tu cedula y contraseña e intenta nuevamente.'
                    }).then(() => {
                        window.location.href = 'login.php';
                    });
                  </script>";
        }
    } else {
        echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Usuario no encontrado'
                }).then(() => {
                    window.location.href = 'login.php';
                });
              </script>";
    }
}

$conn->close();
?>
</body>
</html>
