<?php
session_start();
include '../../includes/header2.php';
include '../../includes/functions.php';
include '../../Conexion/conexion.php';

$errores = [];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = $_POST['nombre'];
    $apellido = $_POST['apellido'];
    $contacto = $_POST['contacto'];
    $cedula = $_POST['cedula'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role_id = $_POST['role_id'];

    // Verificar si el role_id existe en la tabla roles
    $sql = "SELECT id_rol FROM rol WHERE id_rol = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $role_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Verificar si la cédula ya existe para el mismo rol
        $sql = "SELECT u.id_user FROM user u JOIN rol_user ru ON u.id_user = ru.id_user WHERE u.cedula = ? ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $cedula, );
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $errores['cedula'] = 'Esta cédula ya está registrada como usuario.';
        }  else {
                // Insertar usuario
                $sql = "INSERT INTO user (nombre, apellido, contacto, cedula, password) VALUES (?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sssss", $nombre, $apellido, $contacto, $cedula, $password);

                if ($stmt->execute()) {
                    // Obtener el ID del usuario insertado
                    $user_id = $conn->insert_id;

                    // Insertar en rol_user
                    $sql = "INSERT INTO rol_user (id_user, id_rol) VALUES (?, ?)";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ii", $user_id, $role_id);
                    if ($stmt->execute()) {
                        // Guardar mensaje de éxito en sesión
                        $_SESSION['response'] = ['status' => 'success', 'message' => 'Usuario registrado exitosamente.'];
                    } else {
                        $_SESSION['response'] = ['status' => 'error', 'message' => 'Error al asignar el rol.'];
                    }
                } else {
                    $_SESSION['response'] = ['status' => 'error', 'message' => 'Error al registrar el usuario.'];
                }
            }
        
    } else {
        $errores['rol'] = 'El Rol proporcionado no existe.';
    }

    // Mostrar los errores de validación con SweetAlert2
    if (!empty($errores)) {
        $errorMessages = implode('<br>', $errores);
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                html: '$errorMessages'
            });
        </script>";
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar Usuario</title>
    <link rel="stylesheet" href="../../assets/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            background-color: #f4f7fa;
            font-family: 'Arial', sans-serif;
        }

        .form-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            margin-top: 50px;
        }

        h1 {
            font-size: 2rem;
            color: #333;
            margin-bottom: 30px;
        }

        .form-group label {
            font-weight: bold;
        }

        .btn-success {
            border-radius: 25px;
            padding: 10px 30px;
            font-size: 1rem;
            transition: background-color 0.3s, transform 0.2s;
        }

        .btn-success:hover {
            transform: scale(1.05);
        }

        .form-control {
            border-radius: 25px;
        }

        .error {
            color: red;
            font-size: 0.9em;
        }

        .input-group-text {
            background-color: #28a745;
            color: white;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="form-container">
            <h1>Agregar Usuario</h1>
            <form action="agregar_usuarios.php" method="POST">
                <div class="form-group">
                    <label for="nombre">Nombre</label>
                    <input type="text" id="nombre" name="nombre" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="apellido">Apellido</label>
                    <input type="text" id="apellido" name="apellido" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="contacto">Contacto</label>
                    <input type="text" id="contacto" name="contacto" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="cedula">Cédula</label>
                    <input type="text" id="cedula" name="cedula" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="role_id">Rol</label>
                    <select name="role_id" id="role_id" class="form-control" required>
                        <option value="" disabled selected>Selecciona un rol</option>
                        <?php
                        $roles = getAllRoles();
                        foreach ($roles as $rol) {
                            echo "<option value='{$rol['id_rol']}'>{$rol['rol']}</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <input type="password" id="password" name="password" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-success btn-block">Guardar</button>
            </form>
        </div>
    </div>

    <script>
        // Validaciones del lado del cliente
        document.querySelector('form').addEventListener('submit', function(event) {
            var nombre = document.getElementById('nombre').value.trim();
            var apellido = document.getElementById('apellido').value.trim();
            var cedula = document.getElementById('cedula').value;
            var contacto = document.getElementById('contacto').value;

            // Validación de nombres y apellidos (solo letras y espacios)
            var nombreApellidoRegex = /^[a-zA-ZáéíóúÁÉÍÓÚñÑ]+(?: [a-zA-ZáéíóúÁÉÍÓÚñÑ]+)*$/;


            if (!nombreApellidoRegex.test(nombre)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'El nombre solo debe contener letras y espacios.'
                });
                event.preventDefault();
            }

            if (!nombreApellidoRegex.test(apellido)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'El apellido solo debe contener letras y espacios.'
                });
                event.preventDefault();
            }

            // Validación de cédula (Ejemplo: solo números)
            if (!/^\d{7,10}$/.test(cedula)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'La cédula debe ser un número válido entre 7 y 10 dígitos.'
                });
                event.preventDefault();
            }

            // Validación de contacto (Ejemplo: solo números y ciertos caracteres)
            if (!/^[0-9\s\+\-]+$/.test(contacto)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'El contacto debe ser un número válido.'
                });
                event.preventDefault();
            }
        });

        <?php if (isset($_SESSION['response'])) : ?>
        Swal.fire({
            icon: '<?php echo $_SESSION['response']['status']; ?>',
            title: '<?php echo ucfirst($_SESSION['response']['status']); ?>',
            text: '<?php echo $_SESSION['response']['message']; ?>'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '../usuarios.php';  // Redirigir a una página específica
            }
        });
        <?php unset($_SESSION['response']); endif; ?>
    </script>
</body>

</html>
