<?php
/**
 * Licensed under The GPL-3.0 License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @since    2.0.0
 * @author   Christopher Castro <chris@quickapps.es>
 * @link     http://www.quickappscms.org
 * @license  http://opensource.org/licenses/gpl-3.0.html GPL-3.0 License
 */
?>

<h3>About</h3>
<p>
     The Block plugin allows you to create boxes of content, which are rendered into an area, or region, of one or more pages of a website.
     The core's Frontend theme, for example, implements the regions "Right Sidebar" and "Site Footer", and a block may appear in any one of these regions.
     The <?php echo $this->Html->link(__d('block', 'Blocks administration page'), ['plugin' => 'Block', 'controller' => 'manage']); ?> provides an interface
     for assigning a block to a region, and for controlling the order of blocks within regions.
</p>

<h3>Uses</h3>
<dl>
    <dt>Positioning content</dt>
    <dd>
        When working with blocks, remember that all themes do <em>not</em> implement the same regions, or display regions
        in the same way. Blocks are positioned on a per-theme basis. Users with permissions can disable blocks.
        Disabled blocks are listed on the <?php echo $this->Html->link(__d('block', 'Blocks administration page'), ['plugin' => 'Block', 'controller' => 'manage']); ?>,
        but are not displayed in any region.
    </dd>

    <dt>Controlling visibility</dt>
    <dd>
        Blocks can be configured to be visible only on certain pages, only to users of certain roles.
        Some dynamic blocks, such as those generated by plugins, will be displayed only on certain pages.
    </dd>

    <dt>Creating custom blocks</dt>
    <dd>
        Users with permissions can <?php echo $this->Html->link(__d('block', 'add custom blocks'), ['plugin' => 'Block', 'controller' => 'manage', 'action' => 'add']); ?>, which are then listed on
        the <?php echo $this->Html->link(__d('block', 'Blocks administration page'), ['plugin' => 'Block', 'controller' => 'manage']); ?>.
        Once created, custom blocks behave just like default and plugin-generated blocks.
    </dd>
</dl>