<?php
/**
 * Licensed under The GPL-3.0 License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @since    2.0.0
 * @author   Christopher Castro <chris@quickapps.es>
 * @link     http://www.quickappscms.org
 * @license  http://opensource.org/licenses/gpl-3.0.html GPL-3.0 License
 */
namespace User\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Represents "roles" database table.
 *
 */
class RolesTable extends Table
{

    /**
     * Initialize a table instance. Called after the constructor.
     *
     * @param array $config Configuration options passed to the constructor
     * @return void
     */
    public function initialize(array $config)
    {
        $this->addBehavior('Sluggable', ['label' => 'name']);
    }

    /**
     * Default validation rules set.
     *
     * @param \Cake\Validation\Validator $validator The validator object
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->requirePresence('name')
            ->add('name', [
                'notBlank' => [
                    'rule' => 'notBlank',
                    'message' => __d('user', 'You need to provide a role name.'),
                ],
                'length' => [
                    'rule' => ['minLength', 3],
                    'message' => __d('user', 'Role name need to be at least 3 characters long.'),
                ],
            ]);

        return $validator;
    }
}
