<?php

class CourseController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$batchModel = new Batch;
		$this->render('view',array(
			'model'=>$this->loadModel($id),'batchModel'=>$batchModel,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Course;
		$batch=new Batch;
		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation(array($model,$batch));

		if(isset($_POST['Course']))
		{
			$model->attributes=$_POST['Course'];
			$model->created_by=Yii::app()->user->id;
			$model->created_date=new CDbExpression('NOW()');
			if($model->save())
			{
			    if(isset($_POST['Batch']))
			    {
			   	$batch->batch_name=$_POST['Batch']['batch_name'];
			    	$batch->batch_fees=$_POST['Batch']['batch_fees'];
			    	$batch->course_id=$model->course_id;
				$batch->batch_start_date='';
				$batch->batch_end_date='';
				$batch->batch_created_by=Yii::app()->user->id;
				$batch->batch_creation_date=new CDbExpression('NOW()');
			     	$batch->save(false);
			     }
				$this->redirect(array('view','id'=>$model->course_id));
			}
		}

		$this->render('create',array(
			'model'=>$model,'batch'=>$batch
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
		$batch=new Batch;
		// Uncomment the following line if AJAX validation is needed
		 $this->performAjaxValidation($model);

		if(isset($_POST['Course']))
		{
			$model->attributes=$_POST['Course'];
			if($model->save())	
				$this->redirect(array('view','id'=>$model->course_id));
		}
		$this->render('update',array(
			'model'=>$model,'batch'=>$batch
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$st_tran = StudentTransaction::model()->findAll(array('condition'=>'course_id='.$id));
		$batch_d = Batch::model()->findAll(array('condition'=>'course_id='.$id));
		
			if(!empty($st_tran))
			{
				throw new CHttpException(400,'You can not delete this record because it is used in another table.');
			}	
			else
			{
			  $this->loadModel($id)->delete();
			    foreach($batch_d as $b)
			    {
				Batch::model()->findByPk($b->batch_id)->delete();
			    }	
			}
			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Course('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Course']))
			$model->attributes=$_GET['Course'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Course::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='course-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
