﻿/* http://keith-wood.name/calculator.html
   Calculator field entry extension for jQuery v1.4.1.
   Written by Keith Wood (kbwood{at}iinet.com.au) October 2008.
   Licensed under the MIT (https://github.com/jquery/jquery/blob/master/MIT-LICENSE.txt) licence. 
   Please attribute the author if you use it. */
(function($){function Calculator(){this._curInst=null;this._disabledFields=[];this._showingCalculator=false;this._showingKeystrokes=false;this._keyDefs={'_0':['0',this.digit,null,'','0','0'],'_1':['1',this.digit,null,'','1','1'],'_2':['2',this.digit,null,'','2','2'],'_3':['3',this.digit,null,'','3','3'],'_4':['4',this.digit,null,'','4','4'],'_5':['5',this.digit,null,'','5','5'],'_6':['6',this.digit,null,'','6','6'],'_7':['7',this.digit,null,'','7','7'],'_8':['8',this.digit,null,'','8','8'],'_9':['9',this.digit,null,'','9','9'],'_A':['A',this.digit,null,'hex-digit','A','a'],'_B':['B',this.digit,null,'hex-digit','B','b'],'_C':['C',this.digit,null,'hex-digit','C','c'],'_D':['D',this.digit,null,'hex-digit','D','d'],'_E':['E',this.digit,null,'hex-digit','E','e'],'_F':['F',this.digit,null,'hex-digit','F','f'],'_.':['.',this.digit,null,'decimal','DECIMAL','.'],'_+':['+',this.binary,this._add,'arith add','ADD','+'],'_-':['-',this.binary,this._subtract,'arith subtract','SUBTRACT','-'],'_*':['*',this.binary,this._multiply,'arith multiply','MULTIPLY','*'],'_/':['/',this.binary,this._divide,'arith divide','DIVIDE','/'],'_%':['%',this.unary,this._percent,'arith percent','PERCENT','%'],'_=':['=',this.unary,this._equals,'arith equals','EQUALS','='],'+-':['±',this.unary,this._plusMinus,'arith plus-minus','PLUS_MINUS','#'],'PI':['pi',this.unary,this._pi,'pi','PI','p'],'1X':['1/x',this.unary,this._inverse,'fn inverse','INV','i'],'LG':['log',this.unary,this._log,'fn log','LOG','l'],'LN':['ln',this.unary,this._ln,'fn ln','LN','n'],'EX':['eⁿ',this.unary,this._exp,'fn exp','EXP','E'],'SQ':['x²',this.unary,this._sqr,'fn sqr','SQR','@'],'SR':['√',this.unary,this._sqrt,'fn sqrt','SQRT','!'],'XY':['x^y',this.binary,this._power,'fn power','POWER','^'],'RN':['rnd',this.unary,this._random,'random','RANDOM','?'],'SN':['sin',this.unary,this._sin,'trig sin','SIN','s'],'CS':['cos',this.unary,this._cos,'trig cos','COS','o'],'TN':['tan',this.unary,this._tan,'trig tan','TAN','t'],'AS':['asin',this.unary,this._asin,'trig asin','ASIN','S'],'AC':['acos',this.unary,this._acos,'trig acos','ACOS','O'],'AT':['atan',this.unary,this._atan,'trig atan','ATAN','T'],'MC':['#memClear',this.unary,this._memClear,'memory mem-clear','MEM_CLEAR','x'],'MR':['#memRecall',this.unary,this._memRecall,'memory mem-recall','MEM_RECALL','r'],'MS':['#memStore',this.unary,this._memStore,'memory mem-store','MEM_STORE','m'],'M+':['#memAdd',this.unary,this._memAdd,'memory mem-add','MEM_ADD','>'],'M-':['#memSubtract',this.unary,this._memSubtract,'memory mem-subtract','MEM_SUBTRACT','<'],'BB':['#base2',this.control,this._base2,'base base2','BASE_2','B'],'BO':['#base8',this.control,this._base8,'base base8','BASE_8','C'],'BD':['#base10',this.control,this._base10,'base base10','BASE_10','D'],'BH':['#base16',this.control,this._base16,'base base16','BASE_16','H'],'DG':['#degrees',this.control,this._degrees,'angle degrees','DEGREES','G'],'RD':['#radians',this.control,this._radians,'angle radians','RADIANS','R'],'BS':['#backspace',this.control,this._undo,'undo','UNDO',8,'BSp'],'CE':['#clearError',this.control,this._clearError,'clear-error','CLEAR_ERROR',36,'Hom'],'CA':['#clear',this.control,this._clear,'clear','CLEAR',35,'End'],'@X':['#close',this.control,this._close,'close','CLOSE',27,'Esc'],'@U':['#use',this.control,this._use,'use','USE',13,'Ent'],'@E':['#erase',this.control,this._erase,'erase','ERASE',46,'Del'],'  ':['',this.space,null,'space','SPACE'],'_ ':['',this.space,null,'half-space','HALF_SPACE'],'??':['??',this.unary,this._noOp]};this._keyCodes={};this._keyChars={};for(var a in this._keyDefs){if(this._keyDefs[a][4]){this[this._keyDefs[a][4]]=a}if(this._keyDefs[a][5]){if(typeof this._keyDefs[a][5]=='number'){this._keyCodes[this._keyDefs[a][5]]=a}else{this._keyChars[this._keyDefs[a][5]]=a}}}this.regional=[];this.regional['']={decimalChar:'.',buttonText:'...',buttonStatus:'Open the calculator',closeText:'Close',closeStatus:'Close the calculator',useText:'Use',useStatus:'Use the current value',eraseText:'Erase',eraseStatus:'Erase the value from the field',backspaceText:'BS',backspaceStatus:'Erase the last digit',clearErrorText:'CE',clearErrorStatus:'Erase the last number',clearText:'CA',clearStatus:'Reset the calculator',memClearText:'MC',memClearStatus:'Clear the memory',memRecallText:'MR',memRecallStatus:'Recall the value from memory',memStoreText:'MS',memStoreStatus:'Store the value in memory',memAddText:'M+',memAddStatus:'Add to memory',memSubtractText:'M-',memSubtractStatus:'Subtract from memory',base2Text:'Bin',base2Status:'Switch to binary',base8Text:'Oct',base8Status:'Switch to octal',base10Text:'Dec',base10Status:'Switch to decimal',base16Text:'Hex',base16Status:'Switch to hexadecimal',degreesText:'Deg',degreesStatus:'Switch to degrees',radiansText:'Rad',radiansStatus:'Switch to radians',isRTL:false};this._defaults={showOn:'focus',buttonImage:'',buttonImageOnly:false,isOperator:null,showAnim:'show',showOptions:{},duration:'normal',appendText:'',useThemeRoller:false,calculatorClass:'',prompt:'',layout:this.standardLayout,value:0,base:10,precision:10,memoryAsCookie:false,cookieName:'calculatorMemory',cookieExpires:24*60*60,cookiePath:'',useDegrees:false,constrainInput:true,onOpen:null,onButton:null,onClose:null};$.extend(this._defaults,this.regional['']);this.mainDiv=$('<div class="'+this._mainDivClass+'" style="display: none;"></div>').bind('click.calculator',this._focusEntry)}$.extend(Calculator.prototype,{markerClassName:'hasCalculator',propertyName:'calculator',digit:'d',binary:'b',unary:'u',control:'c',space:'s',_mainDivClass:'calculator-popup',_inlineClass:'calculator-inline',_appendClass:'calculator-append',_triggerClass:'calculator-trigger',_disableClass:'calculator-disabled',_inlineEntryClass:'calculator-keyentry',_promptClass:'calculator-prompt',_resultClass:'calculator-result',_focussedClass:'calculator-focussed',_keystrokeClass:'calculator-keystroke',_rtlClass:'calculator-rtl',_rowClass:'calculator-row',_ctrlClass:'calculator-ctrl',_baseActiveClass:'calculator-base-active',_angleActiveClass:'calculator-angle-active',_digitClass:'calculator-digit',_operatorClass:'calculator-oper',_memEmptyClass:'calculator-mem-empty',_keyNameClass:'calculator-keyname',_keyDownClass:'calculator-key-down',_keyStrokeClass:'calculator-keystroke',standardLayout:['  BSCECA','_1_2_3_+@X','_4_5_6_-@U','_7_8_9_*@E','_0_._=_/'],scientificLayout:['@X@U@E  BSCECA','DGRD    _ MC_ _7_8_9_+','SNASSRLG_ MR_ _4_5_6_-','CSACSQLN_ MS_ _1_2_3_*','TNATXYEX_ M+_ _0_.+-_/','PIRN1X  _ M-_   _%_='],setDefaults:function(a){$.extend(this._defaults,a||{});return this},addKeyDef:function(a,b,c,d,e,f,g,h){this._keyDefs[a]=[b,(typeof c=='boolean'?(c?this.binary:this.unary):c),d,e,f,g,h];if(f){this[f]=a}if(g){if(typeof g=='number'){this._keyCodes[g]=a}else{this._keyChars[g]=a}}return this},_attachPlugin:function(a,b){var c=$(a);if(c.hasClass(this.markerClassName)){return}var d=a.nodeName.toLowerCase()!='input';var e=(!d?c:$('<input type="text" class="'+this._inlineEntryClass+'"/>'));var f={options:$.extend({},this._defaults,b),_target:c,_input:e,_inline:d,memory:0,_mainDiv:(d?$('<div class="'+this._inlineClass+'"></div>'):this.mainDiv)};if(f.options.memoryAsCookie){var g=this._getMemoryCookie(f);if(g&&!isNaN(g)){f.memory=g}}this._connectPlugin(a,f);if(d){c.append(e).append(f._mainDiv).bind('click.'+n.propertyName,function(){e.focus()});this._reset(f,'0');this._setValue(f);this._updateCalculator(f)}else if(c.is(':disabled')){this._disablePlugin(a)}},_connectPlugin:function(d,e){var f=$(d);if(f.hasClass(this.markerClassName)){return}if(e.options.appendText){f[e.options.isRTL?'before':'after']('<span class="'+this._appendClass+'">'+e.options.appendText+'</span>')}if(!e._inline){if(e.options.showOn=='focus'||e.options.showOn=='both'){f.bind('focus.'+n.propertyName,this._showPlugin)}if(e.options.showOn=='button'||e.options.showOn=='both'||e.options.showOn=='opbutton'){var g=$(e.options.buttonImageOnly?$('<img/>').attr({src:e.options.buttonImage,alt:e.options.buttonStatus,title:e.options.buttonStatus}):$('<button type="button" title="'+e.options.buttonStatus+'"></button>').html(e.options.buttonImage==''?e.options.buttonText:$('<img/>').attr({src:e.options.buttonImage})));f[e.options.isRTL?'before':'after'](g);g.addClass(this._triggerClass).bind('click.'+n.propertyName,function(){if(n._showingCalculator&&n._lastInput==d){n._hidePlugin()}else{n._showPlugin(d)}return false})}}e._input.bind('keydown.'+n.propertyName,this._doKeyDown).bind('keyup.'+n.propertyName,this._doKeyUp).bind('keypress.'+n.propertyName,this._doKeyPress);if(e._inline){e._mainDiv.bind('keydown.'+n.propertyName,this._doKeyDown).bind('keyup.'+n.propertyName,this._doKeyUp).bind('keypress.'+n.propertyName,this._doKeyPress);e._input.bind('focus.'+n.propertyName,function(){if(!n._isDisabledPlugin(f[0])){e._focussed=true;$('.'+n._resultClass,e._mainDiv).addClass(n._focussedClass)}}).bind('blur.'+n.propertyName,function(){e._focussed=false;$('.'+n._resultClass,e._mainDiv).removeClass(n._focussedClass)})}f.addClass(this.markerClassName).bind('setData.'+n.propertyName,function(a,b,c){e.options[b]=c}).bind('getData.'+n.propertyName,function(a,b){return e.options[b]}).data(this.propertyName,e);e._input.data(this.propertyName,e)},_optionPlugin:function(a,b,c){a=$(a);var d=a.data(this.propertyName);if(!b||(typeof b=='string'&&c==null)){var e=b;b=(d||{}).options;return(b&&e?b[e]:b)}if(!a.hasClass(this.markerClassName)){return}b=b||{};if(typeof b=='string'){var e=b;b={};b[e]=c}if(this._curInst==d){this._hidePlugin()}$.extend(d.options,b);if(d._inline){this._setValue(d)}this._updateCalculator(d)},_destroyPlugin:function(a){a=$(a);if(!a.hasClass(this.markerClassName)){return}var b=a.data(this.propertyName);b._input.unbind('.'+n.propertyName).removeData(this.propertyName);a.removeClass(this.markerClassName).empty().unbind('.'+n.propertyName).removeData(this.propertyName).siblings('.'+this._appendClass).remove().end().siblings('.'+this._triggerClass).remove().end().prev('.'+this._inlineEntryClass).remove()},_enablePlugin:function(b){var c=$(b);if(!c.hasClass(this.markerClassName)){return}var d=b.nodeName.toLowerCase();if(d=='input'){b.disabled=false;c.siblings('button.'+this._triggerClass).each(function(){this.disabled=false}).end().siblings('img.'+this._triggerClass).css({opacity:'1.0',cursor:''})}else if(d=='div'||d=='span'){c.find('.'+this._inlineEntryClass+',button').prop('disabled',false).end().children('.'+this._disableClass).remove()}this._disabledFields=$.map(this._disabledFields,function(a){return(a==b?null:a)})},_disablePlugin:function(b){var c=$(b);if(!c.hasClass(this.markerClassName)){return}var d=b.nodeName.toLowerCase();if(d=='input'){b.disabled=true;c.siblings('button.'+this._triggerClass).each(function(){this.disabled=true}).end().siblings('img.'+this._triggerClass).css({opacity:'0.5',cursor:'default'})}else if(d=='div'||d=='span'){var e=c.children('.'+this._inlineClass);var f=e.offset();var g={left:0,top:0};e.parents().each(function(){if($(this).css('position')=='relative'){g=$(this).offset();return false}});c.find('.'+this._inlineEntryClass+',button').prop('disabled',true);if(c.find('.'+this._disableClass).length==0){c.prepend('<div class="'+this._disableClass+'" style="width: '+e.outerWidth()+'px; height: '+e.outerHeight()+'px; left: '+(f.left-g.left)+'px; top: '+(f.top-g.top)+'px;"></div>')}}this._disabledFields=$.map(this._disabledFields,function(a){return(a==b?null:a)});this._disabledFields[this._disabledFields.length]=b},_isDisabledPlugin:function(a){return(a&&$.inArray(a,this._disabledFields)>-1)},_showPlugin:function(a){a=a.target||a;if(n._isDisabledPlugin(a)||n._lastInput==a){return}var b=$.data(a,n.propertyName);n._hidePlugin(null,'');n._lastInput=a;n._pos=n._findPos(a);n._pos[1]+=a.offsetHeight;var c=false;$(a).parents().each(function(){c|=$(this).css('position')=='fixed';return!c});var d={left:n._pos[0],top:n._pos[1]};n._pos=null;b._mainDiv.css({position:'absolute',display:'block',top:'-1000px',width:'auto'});if($.isFunction(b.options.onOpen)){b.options.onOpen.apply((b._input?b._input[0]:null),[(b._inline?b.curValue:b._input.val()),b])}n._reset(b,b._input.val());n._updateCalculator(b);d=n._checkOffset(b,d,c);b._mainDiv.css({position:(c?'fixed':'absolute'),display:'none',left:d.left+'px',top:d.top+'px'});var e=b.options.duration;e=(e=='normal'&&$.ui&&$.ui.version>='1.8'?'_default':e);var f=function(){n._showingCalculator=true};if($.effects&&$.effects[b.options.showAnim]){var g=b._mainDiv.data();for(var h in g){if(h.match(/^ec\.storage\./)){g[h]=b._mainDiv.css(h.replace(/ec\.storage\./,''))}}b._mainDiv.data(g).show(b.options.showAnim,b.options.showOptions,e,f)}else{b._mainDiv[b.options.showAnim||'show']((b.options.showAnim?e:null),f)}if(!b.options.showAnim){f()}if(b._input[0].type!='hidden'){b._input[0].focus()}n._curInst=b},_reset:function(a,b){b=''+(b||0);b=(a.options.decimalChar!='.'?b.replace(new RegExp(a.options.decimalChar),'.'):b);a.curValue=(a.options.base==10?parseFloat(b):parseInt(b,a.options.base))||0;a.dispValue=this._setDisplay(a);a.prevValue=a._savedValue=0;a._pendingOp=a._savedOp=this._noOp;a._newValue=true},_getMemoryCookie:function(a){var b=new RegExp('^.*'+a.options.cookieName+'=([^;]*).*$');return parseFloat(document.cookie.replace(b,'$1'))},_setMemoryCookie:function(a){if(!a.options.memoryAsCookie){return}var b=a.options.cookieExpires;if(typeof b=='number'){var c=new Date();c.setTime(c.getTime()+b*1000);b=c.toUTCString()}else if(b.constructor==Date){b=c.toUTCString()}else{b=''}document.cookie=a.options.cookieName+'='+a.memory+'; expires='+b+'; path='+a.options.cookiePath},_setValue:function(a){a.curValue=a.options.value||0;a.dispValue=this._setDisplay(a)},_updateCalculator:function(a){var b=this._getBorders(a._mainDiv);a._mainDiv.html(this._generateHTML(a)).removeClass().addClass(a.options.calculatorClass+(a.options.useThemeRoller?' ui-widget ui-widget-content':'')+(a.options.isRTL?' '+n._rtlClass:'')+' '+(a._inline?this._inlineClass:this._mainDivClass));if(this._isDisabledPlugin(a._target[0])){this._disablePlugin(a._target[0])}if(this._curInst==a){a._input.focus()}},_getBorders:function(b){var c=function(a){return{thin:1,medium:3,thick:5}[a]||a};return[parseFloat(c(b.css('border-left-width'))),parseFloat(c(b.css('border-top-width')))]},_checkOffset:function(a,b,c){var d=a._input?this._findPos(a._input[0]):null;var e=window.innerWidth||document.documentElement.clientWidth;var f=window.innerHeight||document.documentElement.clientHeight;var g=document.documentElement.scrollLeft||document.body.scrollLeft;var h=document.documentElement.scrollTop||document.body.scrollTop;var i=0;$('.'+n.propertyName+'-row',a._mainDiv).find('button:last').each(function(){i=Math.max(i,this.offsetLeft+this.offsetWidth+parseInt($(this).css('margin-right'),10))});a._mainDiv.css('width',i);if(a.options.isRTL||(b.left+a._mainDiv.outerWidth()-g)>e){b.left=Math.max((c?0:g),d[0]+(a._input?a._input.outerWidth():0)-(c?g:0)-a._mainDiv.outerWidth())}else{b.left=Math.max((c?0:g),b.left-(c?g:0))}if((b.top+a._mainDiv.outerHeight()-h)>f){b.top=Math.max((c?0:h),d[1]-(c?h:0)-a._mainDiv.outerHeight())}else{b.top=Math.max((c?0:h),b.top-(c?h:0))}return b},_findPos:function(a){while(a&&(a.type=='hidden'||a.nodeType!=1)){a=a.nextSibling}var b=$(a).offset();return[b.left,b.top]},_hidePlugin:function(a,b){var c=this._curInst;if(!c||(a&&c!=$.data(a,this.propertyName))){return}if(this._showingCalculator){b=(b!=null?b:c.options.duration);b=(b=='normal'&&$.ui&&$.ui.version>='1.8'?'_default':b);if($.effects&&$.effects[c.options.showAnim]){c._mainDiv.hide(c.options.showAnim,c.options.showOptions,b)}else{c._mainDiv[(c.options.showAnim=='slideDown'?'slideUp':(c.options.showAnim=='fadeIn'?'fadeOut':'hide'))](c.options.showAnim?b:null)}}if($.isFunction(c.options.onClose)){c.options.onClose.apply((c._input?c._input[0]:null),[(c._inline?c.curValue:c._input.val()),c])}if(this._showingCalculator){this._showingCalculator=false;this._lastInput=null}this._curInst=null},_checkExternalClick:function(a){if(!n._curInst){return}var b=$(a.target);if(!b.parents().andSelf().hasClass(n._mainDivClass)&&!b.hasClass(n.markerClassName)&&!b.parents().andSelf().hasClass(n._triggerClass)&&n._showingCalculator){n._hidePlugin()}},_focusEntry:function(){if(n._curInst&&n._curInst._input){n._curInst._input.focus()}},_doKeyDown:function(e){var a=false;var b=$.data(e.target,n.propertyName);var c=(b&&b._inline?$(e.target).parent()[0]:null);if(e.keyCode==9){n.mainDiv.stop(true,true);n._hidePlugin();if(b&&b._inline){b._input.blur()}}else if(n._showingCalculator||(c&&!n._isDisabledPlugin(c))){if(e.keyCode==18){if(!n._showingKeystrokes){b._mainDiv.find('.'+n._keystrokeClass).show();n._showingKeystrokes=true}a=true}else{var d=n._keyCodes[e.keyCode];if(d){$('button[data-keystroke="'+d+'"]',b._mainDiv).not(':disabled').click();a=true}}}else if(e.keyCode==36&&e.ctrlKey&&b&&!b._inline){n._showPlugin(this)}if(a){e.preventDefault();e.stopPropagation()}return!a},_doKeyUp:function(e){if(n._showingKeystrokes){var a=$.data(e.target,n.propertyName);a._mainDiv.find('.'+n._keystrokeClass).hide();n._showingKeystrokes=false}},_doKeyPress:function(e){var a=$.data(e.target,n.propertyName);if(!a){return true}var b=(a&&a._inline?$(e.target).parent()[0]:null);var c=String.fromCharCode(e.charCode==undefined?e.keyCode:e.charCode);var d=a.options.isOperator||n._isOperator;if(!n._showingCalculator&&!b&&(a.options.showOn=='operator'||a.options.showOn=='opbutton')&&d.apply(a._input,[c,e,a._input.val(),a.options.base,a.options.decimalChar])){n._showPlugin(this);n._showingCalculator=true}if(n._showingCalculator||(b&&!n._isDisabledPlugin(b))){var f=n._keyChars[c==a.options.decimalChar?'.':c];if(f){$('button[data-keystroke="'+f+'"]',a._mainDiv).not(':disabled').click()}return false}if(c>=' '&&a.options.constrainInput){var g=new RegExp('^-?'+(a.options.base==10?'[0-9]*(\\'+a.options.decimalChar+'[0-9]*)?':'['+'0123456789abcdef'.substring(0,a.options.base)+']*')+'$');return(a._input.val()+c).toLowerCase().match(g)!=null}return true},_isOperator:function(a,b,c,d,e){return a>' '&&!(a=='-'&&c=='')&&('0123456789abcdef'.substr(0,d)+'.'+e).indexOf(a.toLowerCase())==-1},_generateHTML:function(a){var b=(!a.options.prompt?'':'<div class="'+this._promptClass+(a.options.useThemeRoller?' ui-widget-header ui-corner-all':'')+'">'+a.options.prompt+'</div>')+'<div class="'+this._resultClass+(a.options.useThemeRoller?' ui-widget-header':'')+(a._focussed?' '+this._focussedClass:'')+'"><span>'+a.dispValue+'</span></div>';for(var i=0;i<a.options.layout.length;i++){b+='<div class="'+this._rowClass+'">';for(var j=0;j<a.options.layout[i].length;j+=2){var c=a.options.layout[i].substr(j,2);var d=this._keyDefs[c]||this._keyDefs['??'];var e=(d[0].charAt(0)=='#'?a.options[d[0].substr(1)+'Text']:d[0]);var f=(d[0].charAt(0)=='#'?a.options[d[0].substr(1)+'Status']:'');var g=(d[3]?d[3].split(' '):[]);for(var k=0;k<g.length;k++){g[k]=this.propertyName+'-'+g[k]}g=g.join(' ');var h=(a.options.useThemeRoller?' ui-state-active':'');var l=(a.options.useThemeRoller?' ui-state-highlight':'');b+=(d[1]==this.space?'<span class="'+this.propertyName+'-'+d[3]+'"></span>':(a._inline&&(d[2]=='._close'||d[2]=='._erase')?'':'<button type="button" data-keystroke="'+c+'"'+(d[1]==this.control?' class="'+this._ctrlClass+(d[0].match(/^#base/)?(d[0].replace(/^#base/,'')==a.options.base?h||' '+this._baseActiveClass:l):(d[0]=='#degrees'?(a.options.useDegrees?h||' '+this._angleActiveClass:l):(d[0]=='#radians'?(!a.options.useDegrees?h||' '+this._angleActiveClass:l):l))):(d[1]==this.digit?(parseInt(d[0],16)>=a.options.base||(a.options.base!=10&&d[0]=='.')?' disabled="disabled"':'')+' class="'+this._digitClass:(d[1]==this.binary?' class="'+this._operatorClass:' class="'+this._operatorClass+(d[0].match(/^#mem(Clear|Recall)$/)&&!a.memory?' '+this._memEmptyClass:''))))+(a.options.useThemeRoller?' ui-state-default':'')+(g?' '+g:'')+'" '+(f?'title="'+f+'"':'')+'>'+(c=='_.'?a.options.decimalChar:e)+(d[5]&&d[5]!=d[0]?'<span class="'+this._keystrokeClass+(a.options.useThemeRoller?' ui-state-error':'')+(d[6]?' '+this._keyNameClass:'')+'">'+(d[6]||d[5])+'</span>':'')+'</button>'))}b+='</div>'}b+='<div style="clear: both;"></div>';b=$(b);b.find('button').bind('mouseover.'+this.propertyName,function(){n._saveClasses=this.className}).bind('mousedown.'+this.propertyName,function(){$(this).addClass(this._keyDownClass+(a.options.useThemeRoller?' ui-state-active':''))}).bind('mouseup.'+this.propertyName,function(){$(this).removeClass().addClass(n._saveClasses)}).bind('mouseout.'+this.propertyName,function(){$(this).removeClass().addClass(n._saveClasses)}).bind('click.'+this.propertyName,function(){n._handleButton(a,$(this))});return b},_setDisplay:function(a){var b=new Number(a.curValue).toFixed(a.options.precision).valueOf();var c=b.replace(/^.+(e.+)$/,'$1').replace(/^[^e].*$/,'');if(c){b=new Number(b.replace(/e.+$/,'')).toFixed(a.options.precision).valueOf()}return parseFloat(b.replace(/0+$/,'')+c).toString(a.options.base).toUpperCase().replace(/\./,a.options.decimalChar)},_sendButton:function(a,b){if($.isFunction(a.options.onButton)){a.options.onButton.apply((a._input?a._input[0]:null),[b,a.dispValue,a])}},_handleButton:function(a,b){var c=this._keyDefs[b.data('keystroke')];if(!c){return}var d=b.text().substr(0,b.text().length-b.children('.'+this._keyStrokeClass).text().length);switch(c[1]){case this.control:c[2].apply(this,[a,d]);break;case this.digit:this._digit(a,d);break;case this.binary:this._binaryOp(a,c[2],d);break;case this.unary:this._unaryOp(a,c[2],d);break}if(n._showingCalculator||a._inline){a._input.focus()}},_noOp:function(a){},_digit:function(a,b){a.dispValue=(a._newValue?'':a.dispValue);if(b==a.options.decimalChar&&a.dispValue.indexOf(b)>-1){return}a.dispValue=(a.dispValue+b).replace(/^0(\d)/,'$1').replace(new RegExp('^(-?)([\\.'+a.options.decimalChar+'])'),'$10$2');if(a.options.decimalChar!='.'){a.dispValue=a.dispValue.replace(new RegExp('^'+a.options.decimalChar),'0.')}var c=(a.options.decimalChar!='.'?a.dispValue.replace(new RegExp(a.options.decimalChar),'.'):a.dispValue);a.curValue=(a.options.base==10?parseFloat(c):parseInt(c,a.options.base));a._newValue=false;this._sendButton(a,b);this._updateCalculator(a)},_binaryOp:function(a,b,c){if(!a._newValue&&a._pendingOp){a._pendingOp(a);a.curValue=(a.options.base==10?a.curValue:Math.floor(a.curValue));a.dispValue=this._setDisplay(a)}a.prevValue=a.curValue;a._newValue=true;a._pendingOp=b;this._sendButton(a,c);this._updateCalculator(a)},_add:function(a){a.curValue=a.prevValue+a.curValue},_subtract:function(a){a.curValue=a.prevValue-a.curValue},_multiply:function(a){a.curValue=a.prevValue*a.curValue},_divide:function(a){a.curValue=a.prevValue/a.curValue},_power:function(a){a.curValue=Math.pow(a.prevValue,a.curValue)},_unaryOp:function(a,b,c){a._newValue=true;b.apply(this,[a]);a.curValue=(a.options.base==10?a.curValue:Math.floor(a.curValue));a.dispValue=this._setDisplay(a);this._sendButton(a,c);this._updateCalculator(a)},_plusMinus:function(a){a.curValue=-1*a.curValue;a.dispValue=this._setDisplay(a);a._newValue=false},_pi:function(a){a.curValue=Math.PI},_percent:function(a){if(a._pendingOp==this._add){a.curValue=a.prevValue*(1+a.curValue/100)}else if(a._pendingOp==this._subtract){a.curValue=a.prevValue*(1-a.curValue/100)}else if(a._pendingOp==this._multiply){a.curValue=a.prevValue*a.curValue/100}else if(a._pendingOp==this._divide){a.curValue=a.prevValue/a.curValue*100}a._savedOp=a._pendingOp;a._pendingOp=this._noOp},_equals:function(a){if(a._pendingOp==this._noOp){if(a._savedOp!=this._noOp){a.prevValue=a.curValue;a.curValue=a._savedValue;a._savedOp(a)}}else{a._savedOp=a._pendingOp;a._savedValue=a.curValue;a._pendingOp(a);a._pendingOp=this._noOp}},_memAdd:function(a){a.memory+=a.curValue;this._setMemoryCookie(a)},_memSubtract:function(a){a.memory-=a.curValue;this._setMemoryCookie(a)},_memStore:function(a){a.memory=a.curValue;this._setMemoryCookie(a)},_memRecall:function(a){a.curValue=a.memory},_memClear:function(a){a.memory=0;this._setMemoryCookie(a)},_sin:function(a){this._trig(a,Math.sin)},_cos:function(a){this._trig(a,Math.cos)},_tan:function(a){this._trig(a,Math.tan)},_trig:function(a,b){a.curValue=b(a.curValue*(a.options.useDegrees?Math.PI/180:1))},_asin:function(a){this._atrig(a,Math.asin)},_acos:function(a){this._atrig(a,Math.acos)},_atan:function(a){this._atrig(a,Math.atan)},_atrig:function(a,b){a.curValue=b(a.curValue);if(a.options.useDegrees){a.curValue=a.curValue/Math.PI*180}},_inverse:function(a){a.curValue=1/a.curValue},_log:function(a){a.curValue=Math.log(a.curValue)/Math.log(10)},_ln:function(a){a.curValue=Math.log(a.curValue)},_exp:function(a){a.curValue=Math.exp(a.curValue)},_sqr:function(a){a.curValue*=a.curValue},_sqrt:function(a){a.curValue=Math.sqrt(a.curValue)},_random:function(a){a.curValue=Math.random()},_base2:function(a,b){this._changeBase(a,b,2)},_base8:function(a,b){this._changeBase(a,b,8)},_base10:function(a,b){this._changeBase(a,b,10)},_base16:function(a,b){this._changeBase(a,b,16)},_changeBase:function(a,b,c){a.options.base=c;a.curValue=(c==10?a.curValue:Math.floor(a.curValue));a.dispValue=this._setDisplay(a);a._newValue=true;this._sendButton(a,b);this._updateCalculator(a)},_degrees:function(a,b){this._degreesRadians(a,b,true)},_radians:function(a,b){this._degreesRadians(a,b,false)},_degreesRadians:function(a,b,c){a.options.useDegrees=c;this._sendButton(a,b);this._updateCalculator(a)},_undo:function(a,b){a.dispValue=a.dispValue.substr(0,a.dispValue.length-1)||'0';a.curValue=(a.options.base==10?parseFloat(a.dispValue):parseInt(a.dispValue,a.options.base));this._sendButton(a,b);this._updateCalculator(a)},_clearError:function(a,b){a.dispValue='0';a.curValue=0;a._newValue=true;this._sendButton(a,b);this._updateCalculator(a)},_clear:function(a,b){this._reset(a,0);this._sendButton(a,b);this._updateCalculator(a)},_close:function(a,b){this._finished(a,b,a._input.val())},_use:function(a,b){if(a._pendingOp!=this._noOp){this._unaryOp(a,this._equals,b)}this._finished(a,b,a.dispValue)},_erase:function(a,b){this._reset(a,0);this._updateCalculator(a);this._finished(a,b,'')},_finished:function(a,b,c){if(a._inline){this._curInst=a}else{a._input.val(c)}this._sendButton(a,b);this._hidePlugin(a._input[0])}});var m=['isDisabled'];function isNotChained(a,b){if(a=='option'&&(b.length==0||(b.length==1&&typeof b[0]=='string'))){return true}return $.inArray(a,m)>-1}$.fn.calculator=function(a){var b=Array.prototype.slice.call(arguments,1);if(isNotChained(a,b)){return n['_'+a+'Plugin'].apply(n,[this[0]].concat(b))}return this.each(function(){if(typeof a=='string'){if(!n['_'+a+'Plugin']){throw'Unknown command: '+a;}n['_'+a+'Plugin'].apply(n,[this].concat(b))}else{n._attachPlugin(this,a||{})}})};var n=$.calculator=new Calculator();$(function(){$('body').append(n.mainDiv).mousedown(n._checkExternalClick)})})(jQuery);