<?php
//Clase ColumnModel, construye modelos de columnas, tanto para la base de datos como para el datagrid.
include("php/ColumnModel.php");

//Clase ExtGridBuilder, Construye un Ext Grid, crea las tablas y las consultas, añade al menu, etc.
include("php/ExtGridBuilder.php");

/* Instanciar el ExtGridBuilder */
//Parametros de ExtGridBuilder
$component = "convocatoria";
$compPlural = "convocatorias";
$section = "acad";
$icon = "convoc.png";
$gb = new ExtGridBuilder($component, $compPlural, $section, $icon);

/* Construir las columnas de la(a) tabla(s) */
//CONSTRUIR COLUMNAS:  Component,  ColName,             ColType,  size,    ColName,           ColIndex,  Table,                     TblId Width, Hidden,   Last
$c1 = new ColumnModel($component, "idConvocatoria",     "int",    null,    "#",               "PRIMARY", "au_convocatorias",        "a",  "30",  "false",  false);
$c2 = new ColumnModel($component, "idTipoConvocatoria", "int",    null,    "#TipoConv",       "FK",      "au_convocatorias",        "a",  "30",  "true",   false);
$c3 = new ColumnModel($component, "idTipoConvocatoria", "int",    null,    "#TipoConv",       "PK",      "au_convocatorias_tipos",  "b",  "0",   "true",   false);
$c4 = new ColumnModel($component, "tipoConvocatoria",   "string", "100",   "Tipo Conv",       false,     "au_convocatorias_tipos",  "b",  "150", "false",  false);
$c5 = new ColumnModel($component, "idCicloAcademico",   "int",    null,    "#Ciclo",          "FK",      "au_convocatorias",        "a",  "30",  "true",   false);
$c6 = new ColumnModel($component, "idCicloAcademico",   "int",    null,    "#ciclo",          "PK",      "au_ciclosAcademicos",     "c",  "0",   "true",   false);
$c7 = new ColumnModel($component, "cicloAcademico",     "string", "100",   "Ciclo Academico", false,     "au_ciclosAcademicos",     "c",  "150", "false",  false);
$c8 = new ColumnModel($component, "idCampaign",         "int",    null,    "#Camp",           "FK",      "au_convocatorias",        "a",  "30",  "true",   false);
$c9 = new ColumnModel($component, "idCampaign",         "int",    null,    "#Camp",           "PK",      "au_campaigns",            "d",  "0",   "true",   false);
$c10= new ColumnModel($component, "campaign",           "string", "100",   "Campa&ntilde;a",  false,     "au_campaigns",            "d",  "150", "false",  false);
$c11= new ColumnModel($component, "convocatoria",       "string", "200",   "Convocatoria",    false,     "au_convocatorias",        "a",  "200", "false",  false);
$c12= new ColumnModel($component, "fechaInicio",        "date",   "100",   "Fecha Inicio",    false,     "au_convocatorias",        "a",  "100", "false",  false);
$c13= new ColumnModel($component, "fechaFin",           "date",   "100",   "Fecha Fin",       false,     "au_convocatorias",        "a",  "100", "false",  false);
$c14= new ColumnModel($component, "idStatus",           "int",    null,    "#Status",         "FK",      "au_convocatorias",        "a",  "30",  "true",   false);
$c15= new ColumnModel($component, "idStatus",           "int",    null,    "#Status",         "PK",      "au_status",               "e",  "0",   "true",   false);
$c16= new ColumnModel($component, "status",             "string", "100",   "Campa&ntilde;a",  false,     "au_status",               "e",  "100", "false",  false);
$c17= new ColumnModel($component, "notas",              "string", "300",   "Notas",           false,     "au_convocatorias",        "a",  "200", "false",  true);

/* Asignar las columnas al componente (se guarda como un arreglo de columnas en ExtGridBuilder->columns)
 * Tambien se crean los querys de seleccion, edicion, insercion y eliminacion */
$gb->createDataModel(array($c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11, $c12, $c13, $c14, $c15, $c16, $c17));
/* Crear los componentes de la vista (Ext) en sections/[componente].js.php */
$gb->createExtView(true, true, true);
/* Crear el modelo de controladores Php en includes/[componente].php */
$gb->createPhpController(true, true, true);
/* Se incluyen estilos, cadenas de traduccion, se añade al menu y se generan includes */
$gb->mergeComponent();

/*EJECUTAR UN ROLLBACK*/
//$gb = new ExtGridBuilder($component, $compPlural, $section, $icon);
//$gb->rollback($component, $styleBck, $mainIncBck, $mainNavBck, $dataSourceBack, $langBck);
/*
 *   $ExtGridBuilder->rollback("convocatoria", "../styles/default.bck.14-11-2010-01:11", "../includes/mainIncludes.bck.14-11-2010-01:11", "../sections/mainNav.js.bck.14-11-2010-01:11", "../sections/dataSources.js.bck.14-11-2010-01:11", "../includes/langs/es_mx.bck.14-11-2010-01:11")
 */
?>

