<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
include("FileIO.php");

/**
 * Description of ExtGridBuilder
 *
 * @author erparom
 */
class ExtGridBuilder {
  var $component;
  var $componentPlural;
  var $componentSection;
  var $componentIcon;
  var $componentFile;
  var $componentController;
  var $columns;
  var $mainComponent;
  var $componentSelect;
  var $componentInsert;
  var $componentUpdate;
  var $componentDelete;

/**
 * Constructor
 * @name ExtGridBuilder
 * @author erparom
 * @param $comp string El nombre del componente a crear
 * @param $plural string El nombre del componente a crear en plural
 * @param $sect string La seccion en la que aprarecerá el componente
 * @param $icon string El icono a utilizar en el componente
 * @version 1
 */
  public function  __construct($comp="foo", $plural="foos", $sect="bar", $icon="foo16x16.png") {
    $this->component = $comp;
    $this->componentSection = $sect;
    $this->componentIcon = $icon;
    $this->componentFile = "../cache/".$comp.".js.php";
    $this->componentController = "../cache/".$comp.".php";
    $this->mainComponent = $comp."Grid";
    //Generación del componente
    echo "<hr /><br />";
    echo "<div style=\"text-align:center;\">GENERACION DEL COMPONENTE</div><br />";
    echo "<b>COMPONENTE INICIALIZADO:</b> Se instanci&oacute; el componente: \"".ucfirst($comp)."\"<br/><br/>\n";
  }

//Deshacer un grid construido con el gridbuilder
  public function rollback($comp="componente", $styleBck="estilos", $mainIncBck="includes", $mainNavBck="navegacion", $dataSourceBack="dataSource", $langBck="idioma"){
  //1-Eliminar estructuras de datos creadas con createDataModel
    /*Actualmente no se crea nada, solo se instancian objetos*/

  //2-Eliminar el archivo de vista creado
    unlink($this->componentFile) or die("ALERTA!-No se pudo eliminar el archivo de componentes<br/>\n");

  //3-Eliminar el archivo de controlador creado
    unlink($this->componentController) or die("ALERTA!-No se pudo eliminar el archivo de componentes<br/>\n");
  
  //4-Deshacer los cambios realizados a los archivos, eliminando lineas o restaurando respaldos, segun el caso
    /*Rollback de la hoja de estilos*/
    if(copy($styleBck, "../styles/default.css")){
     echo "EXITO!-Se restaur&oacute; '$styleBck' a '../styles/default.css' y se borr&oacute; el respaldo.<br/>\n";
     unlink($styleBck);
    } else{
     echo "ALERTA!-No se pudo restaurar '$styleBck' a '../styles/default.css' <br/>\n";
    }

    /*Rollback del archivo de includes*/
    if(copy($mainIncBck, "../includes/mainIncludes.php")){
     echo "EXITO!-Se restaur&oacute; '$mainIncBck' a '../includes/mainIncludes.php' y se borr&oacute; el respaldo.<br/>\n";
     unlink($mainIncBck);
    } else{
     echo "ALERTA!-No se pudo restaurar '$mainIncBck' a '../includes/mainIncludes.php' <br/>\n";
    }

    /*Rollback del archivo de navegacion*/
    if(copy($mainNavBck, "../sections/mainNav.js.php")){
     echo "EXITO!-Se restaur&oacute; '$mainNavBck' a '../sections/mainNav.js.php' y se borr&oacute; el respaldo.<br/>\n";
     unlink($mainNavBck);
    } else{
     echo "ALERTA!-No se pudo restaurar '$mainNavBck' a '../sections/mainNav.js.php' <br/>\n";
    }

    /*Rollback del data source*/
    if(copy($dataSourceBack, "../sections/dataSources.js.php")){
     echo "EXITO!-Se restaur&oacute; '$dataSourceBack' a '../sections/dataSources.js.php' y se borr&oacute; el respaldo.<br/>\n";
     unlink($dataSourceBack);
    } else{
     echo "ALERTA!-No se pudo restaurar '$dataSourceBack' a '../sections/dataSources.js.php' <br/>\n";
    }

    /*Rollback del archivo de idiomas*/
    if(copy($langBack, "../includes/langs/es_mx.php")){
     echo "EXITO!-Se restaur&oacute; '$langBack' a '../includes/langs/es_mx.php' y se borr&oacute; el respaldo.<br/>\n";
     unlink($langBack);
    } else{
     echo "ALERTA!-No se pudo restaurar '$langBack' a '../includes/langs/es_mx.php' <br/>\n";
    }
  }

  public function createDataModel($cols){
//ASIGNAR COLUMNAS AL COMPONENTE
    foreach ($cols as $col) {
      $this->columns[] = $col;
       echo "-A&ntilde;adida columna '$col->field' de la tabla '$col->table' al modelo<br />\n";
    }
    echo "<hr /><br />";
    echo "<div style=\"text-align:center;\">CREACION DE DATOS</div><br />\n";
//ARMAR QUERYS
  //Contar las tablas de origen
    $cantTablas=0;
    $ids=array('a','b','c','d','e','f','g','h','i','j','k');
    //Armar arreglo de tablas:
    $tbArr[]=null;
    $tbiArr[]=null;
    foreach ($this->columns as $col) {
      $tbtmp = $col->table;
      $tbtmpi = $col->tbIdentifier;
      if(!in_array($tbtmp, $tbArr)){
        $tbArr[]=$tbtmp;
        $tbiArr[]=$tbtmpi;
        echo "-La tabla '$tbtmp' con identificador '$tbtmpi' fue instanciada...<br />\n";
      }
    }
    $numTbl = count($tbArr)-1;
    echo "NumTablas = $numTbl<br />\n";
    //Hacer SELECT mixto para las tablas
    $select = "SELECT ";
    //Evaluar a que tabla pertenece y signar el identificador
    foreach ($this->columns as $col) {
      for($i=1;$i<= $numTbl;$i++){
        if($col->table==$tbArr[$i] && $col->width != "0"){ //Poner el campo y validar que no sea de w=0 (no mostrar)
          $select.="$col->tbIdentifier.$col->field";
          if($col->index == "PRIMARY"){
            $primaryVal="$col->tbIdentifier.$col->field";
          }
          $select.=$col->last == true?" ":", ";
        }
      }
    }
  //Armar tablas para el FROM
    for($i=1;$i<=$numTbl;$i++){
      $tables.="$tbArr[$i] $tbiArr[$i]";
      if($i<$numTbl){$tables.=", ";}
    }
    $from="FROM $tables";

  //Armar el WHERE
    $where="WHERE ";
    $numRels=0;
    foreach ($this->columns as $colFK) { //Recorrer columnas
      if($colFK->index == "FK"){ //Establecer Foreign Keys
        $numRels++;
        $colRel = $colFK->field; //Este es el campo a relacionar
        foreach ($this->columns as $colPK) { //Buscar su relacion
          if($colPK->field == $colRel && $colPK->index == "PK"){
            if($numRels>=2){$where.=" AND ";}
            $where.="$colFK->tbIdentifier.$colFK->field = $colPK->tbIdentifier.$colPK->field";
          }
        }
      }
    }

  //Armar el ORDER
    $order.="ORDER BY $primaryVal";
    echo "El select general a consultar para el grid es:<br /><br />\n\n<i>".
         "\t&nbsp;$select<br />\n".
         "\t&nbsp;$from<br />\n".
         "\t&nbsp;$where<br />\n".
         "\t&nbsp;$order</i><br /><br />  \n\n";
  //Asignar el select query al componente
    $this->componentSelect = "$select\n\t$from\n\t$where\n\t$order";
    //Por cada tabla procesar funciones:
    foreach($tbArr as $t){
    //Si NEW=true, poner INSERT
    //Si EDIT=true, poner UPDATE
    //Si DELETE=true, poner DELETE
    }



//QUERYS DE CREACION DE DATOS
    echo "<b>MODELO DE DATOS CREADO CREADO:</b> Se creo el modelo de datos (tabla y sus columnas).<br/><br/>\n";
    //Querys de la base de datos
    echo "<b>QUERYS PARA CREAR MODELO E INSERTAR DATOS:</b> Muestra de consulta de creaci&oacute;n de tabla e inserci&oacute;n de datos<br/>\n".
         "-CREAR LA TABLA DE ".strtoupper($this->component).":<br /><code>".
         "\tCREATE TABLE au_".$this->componentPlural." (<br />\n";
    $indexed = false;
    foreach ($this->columns as $col) {
      $field = "\t\t&nbsp;&nbsp;&nbsp;";
      $field.=$col->field." ";
      if($col->fieldType=="string"){
        $field.="VARCHAR";
        $field.="(".$col->fieldSize.") ";
      }else{
        $field.=strtoupper($col->fieldType)." ";
      }
      $field.="NOT NULL ";
      if($col->index && $col->index == "PRIMARY"){
        $field.="AUTO_INCREMENT PRIMARY KEY";
      }
      $field.=",<br />\n";
      if($col->index == "INDEX"){
        $indexed=true;
      }
      echo $field;
    }
    if($indexed){
      $ind =  "\t\t&nbsp;&nbsp;&nbsp;INDEX (";
      foreach ($this->columns as $col) {
        if($col->index == "INDEX"){
          $ind.=$col->field;
        }
      }
      $ind.=")<br />\n";
    }
    echo  "\t) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;<br />\n".
         "</code><br />\n".
         "-INSERTAR DATOS A LA TABLA DE ".strtoupper($this->component).":<br /><code>".
         "\tINSERT INTO au_perros (perro, idTipoPerro, tipoPerro)<br />\n".
         "\tVALUES ('Mixo', 1, 'Gatilisco');<br />\n".
         "</code><br /><br />\n";
  }

  public function createExtView($insert=false, $edit=false, $delete=false){

    $file="<script type=\"text/javascript\">\n";

    //Create Insert New Function and New Window
    if($insert){
      $file.=$this->addNewFunct();
      $file.=$this->addNewWindow(700, 400);
    }

    //Create Edit Record Function and Edit Window
    if($edit){
      $file.=$this->addEditFunct();
      $file.=$this->addEditWindow(700, 400);
    }

    //Create Delete Record Function
    if($delete){ $file.=$this->addDeleteFunct(); }

    //Create Grid Toolbar
    $file.=$this->addGridTB($insert, $edit, $delete);

    //Create Grid Cell Context Menu
    $file.=$this->addGridContext($edit, $delete);

    //Create Main Grid
    $file.=$this->addGrid($insert, $edit, $delete);

    $file.="</script>";

    //Create File for Grid and Subcomponents
    $fileHandle = fopen($this->componentFile, 'w') or die("can't open file");
    if($fileHandle==false){
      echo "<hr /><br />";
      echo "<div style=\"text-align:center;\">ERROR</div><br />";
      echo "<b>ERROR:</b> No se pudo crear el archivo ".$this->componentFile."<br/>\n";
    }else{
      fwrite($fileHandle, $file);
      fclose($fileHandle);
      echo "<hr /><br />";
      echo "<div style=\"text-align:center;\">GENERACION DE VISTAS</div><br />";
      echo "<b>VISTA EXT CREADA:</b> Se creo el grid en el archivo \"".$this->componentFile."\"<br/><br/>\n";
      //Inclusion de componente al portal
      echo "<b>INCLUIR COMPONENTE EN EL PORTAL:</b> El archivo generado (\"".$this->component.".js.php\") debe situarse dentro de \"sections/\"<br>\n".
      "y debe ser incluido a mainIncludes.php con la siguiente linea:<br>\n".
      "\t\t&nbsp;&nbsp;&nbsp;//".strtoupper($this->componentSection)."-".strtoupper($this->component)."<br/>\n".
      "\t\t&nbsp;&nbsp;&nbsp;<i>include(\"sections/".$this->component.".js.php\");</i><br/><br/>\r";
      //Añadir componente al menu
      echo "<b>A&Ntilde;ADIR COMPONENTE AL MENU DE NAVEGACION:</b> El componente debe ser a&ntilde;adido a \"mainNav.js.php\" con la siguiente linea:<br>\n".
      "\t\t&nbsp;&nbsp;&nbsp;-<i>case '".$this->componentSection."-".$this->component."': item = ".$this->mainComponent.";break;</i><br/>\r".
      "<b>NOTA:</b>En la base de datos debe existir la entrada de menu<br/><br/>\r";

      //Codigo del datasource
      $dataSource = "<b>CONTROLADOR EXT CREADO:</b>El c&oacute;digo para el dataSource debe ir en \"dataSources.js.php\" y es:<br/>\n".
      "<i>/*---------------------------------------".strtoupper($this->componentSection)."-".
      strtoupper($this->component)."--------------------------------------------*/<br/>\n".
      "var ".$this->component."Store = new Ext.data.JsonStore({<br/>\n".
      "\t\t&nbsp;&nbsp;&nbsp;id:'id".ucfirst($this->component)."', totalProperty:'totalCount', root:'rows',<br/>\n".
      "\t\t&nbsp;&nbsp;&nbsp;url:'includes/".$this->component.".php?task=LISTING', autoLoad:true,<br/>\n".
      "\t\t&nbsp;&nbsp;&nbsp;fields:<br/>\n\t\t\t&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[";
      foreach ($this->columns as $col) {
        $dataSource.="{name:'".$col->field."', type:'".$col->fieldType."'}, ";
      }
      $dataSource.="{name:''}]<br/>\r";
      $dataSource.="});<br/>\n";
      $dataSource.="/*---------------------------------------".strtoupper($this->componentSection)."-".
      strtoupper($this->component)."--------------------------------------------*/</i><br/><br/>\n";
      echo $dataSource;

      //Para el archivo de traduccion
      $trans =  "<b>TRADUCCION CREADA:</b>La traduccion para las cadenas debe ir dentro de \"ex_mx.php\" y es:<br/>\n".
      "//".strtoupper($this->componentSection)."-".strtoupper($this->component)."<br/>\n".
      "<i>\$s['".$this->component."BtnHelp'] = 'Ayuda sobre ".ucfirst($this->componentPlural)."';<br/>\n".
      "\$s['".$this->component."GridTitle'] = 'Panel de ".$this->componentPlural."';<br/>\n";
      foreach ($this->columns as $col) {
        $trans.=$col->label." = '".$col->fieldName."';<br/>\n";
      }
      $trans.="<br/>\n";
      echo $trans;
    }

  }

  public function createPhpController($insert=false, $edit=false, $delete=false){
    $file ="<?php\n";
    $file.=
"require_once(\"../includes/config.ini.php\");
require_once(\"../includes/tools.php\");

mysql_connect(DB_SERVER, DB_USER, DB_PASS) or
  die(\"No se pudo conectar: \" . mysql_error());
mysql_select_db(DB_NAME);

function codeDate (\$date) {
  \$tab = explode (\"-\", \$date);
  \$r = \$tab[2].\"-\".\$tab[1].\"-\".\$tab[0];
  return \$r;
}";
    foreach ($this->columns as $col) {
      $c.="a.".$col->field.", ";
      $tbl=$col->table;
    }
    $c.="1 AS void";
    $file.=
"

function getList(){
  \$query = \"$this->componentSelect\";
  \$result0 = mysql_query(\$query) or die('{\"success\":\"false\", \"msg\":\"Error=, '.mysql_error().', Query='.\$query.'\"}');
  \$rows = mysql_num_rows(\$result0);
  \$start=(integer) (isset(\$_REQUEST['start']) ? \$_REQUEST['start'] : 0);
  \$end=(integer) (isset(\$_REQUEST['limit']) ? \$_REQUEST['limit'] : \$rows);
  \$limit = \$query.\" LIMIT \".\$start.\",\".\$end;
  \$result = mysql_query(\$limit);
  if(\$rows>0){
    while(\$rec = mysql_fetch_array(\$result)){
";
    foreach ($this->columns as $col) {
      if($col->fieldType=="int"){
        $file.="\t\$res['".$col->field."']=\$rec['".$col->field."'];\n";
      }else{
        $file.="\t\$res['".$col->field."']=utf8_encode(\$rec['".$col->field."']);\n";
      }
    }
    $file.=
"\t\$arr[] = \$res;
    }
    \$jsonresult = JEncode(\$arr);
    echo '({\"totalCount\":\"'.\$rows.'\",\"rows\":'.\$jsonresult.'})';
  } else {
    echo '({\"totalCount\":\"0\", \"rows\":\"{}\"})';
  }
}
";
    if($insert){
      $file.=
"
insert".ucfirst($this->component)."(){
  \$qry=\"$this->componentInsert\";       
  \$res=mysql_query(\$qry) or die('{\"success\":false, \"msg\":\"Failure:('.\$qry.')\"}');
  if (\$res) {
    \$id=mysql_insert_id();
    echo '{\"success\":true, \"msg\":\"\$id\"}';
  }
}

";
    }
    if($edit){
      $file.=
"
edit".ucfirst($this->component)."(){
  \$qry=\"$this->componentUpdate\".\$_REQUEST['ID'];
  \$res=mysql_query(\$qry) or die('{\"success\":false, \"msg\":\"Failure:('.\$qry.')\"}');
  if (\$res) {
    echo '{\"success\":true, \"msg\":\"ok\"}';
  }
}

";
    }
    if($delete){
      $file.=
"
delete".ucfirst($this->component)."(){
  \$qry=\"$this->componentDelete\".\$_REQUEST['ID'];
  \$res=mysql_query(\$qry) or die('{\"success\":false, \"msg\":\"Failure:('.\$qry.')\"}');
  if(\$res) {
    echo '{\"success\":true, \"msg\":\"ok\"}';
  }
}

";
    }
    $file.=
"

\$task = '';
if (isset(\$_REQUEST['task'])){ \$task = \$_REQUEST['task']; }
switch(\$task){
  case \"LISTING\":
    getList();
    break;
";
    if($insert){
      $file.=
"
  case \"NEW\":
    insert".ucfirst($this->component)."();
    break;
";
    }
    if($edit){
      $file.=
"
  case \"EDIT\":
    edit".ucfirst($this->component)."();
    break;
";
    }
    if($delete){
      $file.=
"
  case \"DELETE\":
    delete".ucfirst($this->component)."();
    break;
";
    }
    $file.=
"
  default:
    echo \"{failure:true}\";
    break;
}
";
    $file.=
"?>";

    //Create File for Grid and Subcomponents
    $fileHandle = fopen($this->componentController, 'w') or die("can't open file");
    if($fileHandle==false){
      echo "<hr /><br />";
      echo "<div style=\"text-align:center;\">ERROR</div><br />";
      echo "<b>ERROR:</b> No se pudo crear el archivo ".$this->componentController."<br/><br/>\n";
    }else{
      fwrite($fileHandle, $file);
      fclose($fileHandle);
      echo "<hr /><br />";
      echo "<div style=\"text-align:center;\">GENERACION DE CONTROLADORES</div><br />";
      echo "<b>CONTROLADOR PHP CREADO:</b> Se creo controlador en el archivo ".$this->componentController."<br/><br/>\n";
      //Inclusion de controlador al portal
      echo "<b>INCLUIR CONTROLADOR EN EL PORTAL:</b> El archivo generado (\"".$this->component.".php\") debe situarse dentro de \"includes/\"<br/><br/>\r";
    }

  }

  public function mergeComponent(){
  /*Añadir las lineas correspondientes a todos los archivos de la aplicación*/
    echo "<hr /><br />";
    echo "<div style=\"text-align:center;\">EDICION DE ARCHIVOS DE LA APLICACION</div><br />\n";
  //Insertar el icono en la hoja de estilos:
    $archivo = "../styles/default.css";
    $io = new FileIO($archivo, "r", "../cache/", "../styles/");
    $style=".".$this->componentSection."-".$this->component."{background-image:url(../images/icons/".$this->componentIcon.") !important;}\n";
    $styleBck=$io->process("Sections - $this->componentSection", $style);
    if($styleBck!=false){
      echo "<b>ESTILOS A&Ntilde;ADIDOS:</b> '".$style."' fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }else{
      echo "<b>ESTILOS NO A&Ntilde;ADIDOS:</b> Hubo un error al procesar '".$style."' y no fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }

  //Añadir el include del componente a mainIncludes.php
    $archivo = "../includes/mainIncludes.php";
    $io = new FileIO($archivo, "r", "../cache/", "../includes/");
    $include = "\t//".ucfirst($this->componentSection)." / ".  ucfirst($this->component)."\ninclude(\"sections/".$this->component.".js.php\"); //MAIN\n\n";
    $mainIncBck=$io->process("//".ucfirst($this->componentSection), $include);
    if($mainIncBck!=false){
      echo "<b>INCLUDE A&Ntilde;ADIDO:</b> '".$include."' fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }else{
      echo "<b>INCLUDE NO A&Ntilde;ADIDO:</b>Hubo un error al procesar '".$include."' y no fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }
    
  //Añadir el componente al arbol de navegacion en mainNav.js.php
    $archivo = "../sections/mainNav.js.php";
    $io = new FileIO($archivo, "r", "../cache/", "../sections/");
    $navCase = "\t\tcase '".$this->componentSection."-".$this->component."': item = ".$this->mainComponent.";break;\n";
    $mainNavBck=$io->process("//".ucfirst($this->componentSection), $navCase);
    if($mainNavBck!=false){
      echo "<b>MENU A&Ntilde;ADIDO:</b> '".$navCase."' fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }else{
      echo "<b>MENU NO A&Ntilde;ADIDO:</b>Hubo un error al procesar '".$navCase."' y no fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }

  //Añadir el datasource a dataSources.js.php
    $archivo = "../sections/dataSources.js.php";
    $io = new FileIO($archivo, "r", "../cache/", "../sections/");
    $dataSource = "/*---------------------------------------".strtoupper($this->componentSection)."-".
    strtoupper($this->component)."--------------------------------------------*/\n".
    "var ".$this->component."Store = new Ext.data.JsonStore({\n".
    "\t\tid:'id".ucfirst($this->component)."', totalProperty:'totalCount', root:'rows',\n".
    "\t\turl:'includes/".$this->component.".php?task=LISTING', autoLoad:true,\n".
    "\t\tfields:[";
    foreach ($this->columns as $col) {
      $dataSource.="{\t\t\tname:'".$col->field."', type:'".$col->fieldType."'}, ";
    }
    $dataSource.="{name:''}]\r";
    $dataSource.="});\n";
    $dataSource.="/*---------------------------------------".strtoupper($this->componentSection)."-".
    strtoupper($this->component)."--------------------------------------------*/\n\n";
    $dataSourceBack=$io->process("//".ucfirst($this->componentSection), $dataSource);
    if($dataSourceBack != false){
      echo "<b>DATASOURCE A&Ntilde;ADIDO:</b> '".$dataSource."' fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }else{
      echo "<b>DATASOURCE NO A&Ntilde;ADIDO:</b>Hubo un error al procesar '".$dataSource."' y no fue a&ntilde;adido a '".$archivo."'<br /><br />\n";
    }
    

  //Añadir las lineas de traduccion a ex_mx.php
    $archivo = "../includes/langs/es_mx.php";
    $io = new FileIO($archivo, "r", "../cache/", "../includes/langs/");
    $trans="\n\$s['".$this->component."BtnHelp'] = 'Ayuda sobre ".ucfirst($this->componentPlural)."';\n".
           "\$s['".$this->component."GridTitle'] = 'Panel de ".$this->componentPlural."';\n".
           "\$s['".$this->component."NewFormTitle'] = 'A&ntilde;adir ".ucfirst($this->component)."';\n".
           "\$s['".$this->component."EditFormTitle'] = 'Editar ".ucfirst($this->component)."';\n";
    foreach ($this->columns as $col) {
      $trans.=$col->label." = '".$col->fieldName."';\n";
    }
    $langBck=$io->process("/*".strtoupper($this->componentSection)."*/", $trans);
    if($langBck != false){
      echo "<b>TRADUCCI&Oacute;N A&Ntilde;ADIDA:</b> '".$trans."' fue a&ntilde;adida a '".$archivo."'<br /><br />\n";
    }else{
      echo "<b>TRADUCCI&Oacute;N NO A&Ntilde;ADIDA:</b>Hubo un error al procesar '".$trans."'y no fue a&ntilde;adida a '".$archivo."'<br /><br />\n";
    }

  //Regresar la llamada para rollback
    echo "<hr /><br />";
    echo "<div style=\"text-align:center;\">INSTRUCCIONES DE ROLLBACK</div><br />\n";
    echo "<br>La operaci&oacute;n de rollback deber&aacute; ejecutarse con:<br />\n".
         "\t\t&nbsp;&nbsp;<i>\$ExtGridBuilder->rollback(\"$this->component\", \"$styleBck\", \"$mainIncBck\", \"$mainNavBck\", \"$dataSourceBack\", \"$langBck\")</i>";
  }

  private function addNewFunct(){
    $f =
"function add".ucfirst($this->component)."(){
  displayWindow(".$this->component."NewWin);
}\n";
    return $f;
  }

  private function addEditFunct(){
    $f =
"function edit".ucfirst($this->component)."(){
  if(checkSelected(".$this->component."Grid)){
    displayWindow(".$this->component."EditWin);
  }
}\n";
    return $f;
  }

  private function addDeleteFunct(){
    //Get Id
    foreach ($this->columns as $col) {
      if($col->index == 'PRIMARY'){
        $primCol = $col->field;
      }
    }

    $f =
"function delete".ucfirst($this->component)."(){
  if(checkSelected(".$this->component."Grid)){
    var selectedRow = ".$this->component."Grid.selModel.getSelected();
    Ext.MessageBox.confirm('<?=\$s['alertDeleteRecord']?>', '<?=\$s['alertConfirmDelete']?>',
        function(btn){
          if(btn=='yes'){
            var id".ucfirst($this->component)." = selectedRow.json.id".$primCol.";
            deleteData('includes/".$this->component.".php?task=DELETE".strtoupper($this->component)."', id".ucfirst($this->component).");
            ".$this->component."Grid.getStore().reload();
          }
        }
    );
  } else{Ext.MessageBox.alert('<?=\$s['alertError']?>','<?=\$s['alertDataDeleteFailure']?>');}
}\n";
    return $f;
  }

  private function addGridTB($i, $e, $d){
    $f =
"var ".$this->component."GridTB = new Ext.Toolbar({
  autoShow:true,
  items: [\n";
    if($i){$f.="   {text: '<?=\$s['gridsBtnAdd']?>', iconCls:'new', handler: add".ucfirst($this->component)."}, '-',\n";}
    if($e){$f.="   {text: '<?=\$s['gridsBtnEditSel']?>', iconCls:'editIcon', handler: edit".ucfirst($this->component)."}, '-',\n";}
    if($d){$f.="   {text: '<?=\$s['gridsBtnDeleteSel']?>', iconCls:'deleteIcon', handler: delete".ucfirst($this->component)."}, '-',\n";}
    $f.=
"    {xtype:'splitbutton', text:'<?=\$s['gridsBtnActions']?>', iconCls:'apps', disabled:true, menu:[
      {text: '<?=\$s['gridsBtnActions']?>', iconCls:'apps', handler: function(){}}
    ]}, '-',
    {xtype:'splitbutton',text: '<?=\$s['gridsBtnEditCat']?>',iconCls:'categories',menu:[
      {text: '<?=\$s['gridsBtnEditCat']?>', iconCls:'categories', handler: function(){}}
    ]}, '-',
    {text: '<?=\$s['".$this->component."BtnHelp']?>', iconCls:'help', handler: function(){displayWindow(helpWin);}},  '->',
    {text: '<?=\$s['gridsBtnSearch']?>', iconCls:'search', handler: function(){}}, '-',
    {text: '<?=\$s['gridsBtnPrint']?>', iconCls:'print', handler: function(){}}
  ]
});\n";
    return $f;
  }

  private function addGridContext($e, $d){
    $f =
"var ".$this->component."GridContext = new Ext.menu.Menu({
    id: '".$this->component."GridContext',
    items: [";
    if($e){$f.="\t\t\t{text: '<?=\$s['gridsBtnEditSel']?>', iconCls:'editIcon', handler: edit".ucfirst($this->component)."},\n";}
    if($d){$f.="\t\t\t{text: '<?=\$s['gridsBtnDeleteSel']?>', iconCls:'deleteIcon', handler: delete".ucfirst($this->component)."},\n";}
    $f.=
"      {text: '<?=\$s['gridsBtnActions']?>', iconCls:'apps', handler: function(){}}
    ]
});\n";
    return $f;
  }

  private function addGrid($i, $e, $d){
    $opsPos=0;
    if($i) $opsPos+=2;
    if($e) $opsPos+=2;
    if($d) $opsPos+=2;
    $component = $this->component."Grid";
    $f=
"var ".$component." = new Ext.grid.GridPanel({
  autoShow:true,
  stripeRows: true,
  tbar: ".$component."TB,
  sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
  bbar: new Ext.PagingToolbar({
    store: ".$this->component."Store,
    displayInfo:true,
    displayMsg:'<?=\$s['pagingBarDisplaying']?>',
    emptyMsg:'<?=\$s['pagingBarNoData']?>',
    firstText:'<?=\$s['pagingBarFirstPage']?>',
    lastText:'<?=\$s['pagingBarLastText']?>',
    nextText:'<?=\$s['pagingBarNextText']?>',
    prevText:'<?=\$s['pagingBarPrevText']?>',
    refreshText:'<?=\$s['pagingBarRefreshText']?>',
    pageSize:20
  }),
  forceFit:true,
  store:".$this->component."Store,
  listeners:{
    scope:this,
    'rowcontextmenu': function(grid, rowIndex, e){
      e.stopEvent();
      var coords = e.getXY();
      ".$component."Context.rowRecord = grid.store.getAt(rowIndex);
      grid.selModel.selectRow(rowIndex);
      ".$this->component."Actual = rowIndex;
      ".$component."Context.showAt([coords[0], coords[1]]);
    },
    'cellclick':function(){
      $this->componentGridTB.getComponent($opsPos).enable();
    }
  },
  columns:[\n";
    foreach ($this->columns as $col) {
      if($col->width!="0"){
        if($col->index == 'PRIMARY'){
          $f.="\t\t{id:'".$col->field."',header:\"#\",width:30,sortable:true,dataIndex:'".$col->field."'},\n";
        }else{
          $f.="\t\t{header:\"<?=\$s['".$component."Col".ucfirst($col->field)."']?>\",width:".$col->width.",sortable:true,dataIndex:'".$col->field."',hidden:".$col->hidden."},\n";
        }
      }
    }
    $f.="]});\n";
    return $f;
  }

  private function addNewWindow($w, $h){
    $f=
"var ".$this->component."NewForm =  new Ext.form.FormPanel({
  title:'<?=\$s['".$this->component."NewFormTitle']?>',
  id:'".$this->component."NewFormContainer',
  formId:'".$this->component."NewFormfrm',
  autoWidth:true,
  layout:'form',
  bodyStyle:'padding:10px 10px 10px 10px',
  items:[{html:'add frm items'},{html:'that correspond to table'}],
  buttons:[{
    text:'<?=\$s['btnSave']?>',
    iconCls:'save',
    handler: function(){}
  }, {
    text: '<?=\$s['btnCancel']?>',
    iconCls:'cancel',
    handler: function(){".$this->component."NewForm.getForm().reset();}
  }]
});
var ".$this->component."NewWin = new Ext.Window({
  title: '<?=\$s['".$this->component."NewWinTitle']?>',
  closable:true,
  closeAction:'hide',
  width:".$w.",
  height:".$h.",
  maximizable:true,
  plain:true,
  layout: 'fit',
  iconCls: 'add',
  buttons:[{
    text:'<?=\$s['btnClose']?>',
    iconCls:'close',
    handler: function(){".$this->component."NewWin.hide();}
  }],
  items: ".$this->component."NewForm
});\n";
    return $f;
  }

  private function addEditWindow($w, $h){
    $f=
"var ".$this->component."EditForm =  new Ext.form.FormPanel({
  title:'<?=\$s['".$this->component."EditFormTitle']?>',
  id:'".$this->component."EditFormContainer',
  formId:'".$this->component."EditFormfrm',
  autoWidth:true,
  layout:'form',
  bodyStyle:'padding:10px 10px 10px 10px',
  items:[{html:'add frm items'},{html:'that correspond to table'}],
  buttons:[{
    text:'<?=\$s['btnSave']?>',
    iconCls:'save',
    handler: function(){}
  }, {
    text: '<?=\$s['btnCancel']?>',
    iconCls:'cancel',
    handler: function(){".$this->component."EditForm.getForm().reset();}
  }]
});
var ".$this->component."EditWin = new Ext.Window({
  title: '<?=\$s['".$this->component."EditWinTitle']?>',
  closable:true,
  closeAction:'hide',
  width:".$w.",
  height:".$h.",
  maximizable:true,
  plain:true,
  layout: 'fit',
  iconCls: 'edit',
  buttons:[{
    text:'<?=\$s['btnClose']?>',
    iconCls:'close',
    handler: function(){".$this->component."EditWin.hide();}
  }],
  items: ".$this->component."EditForm
});\n";
    return $f;
  }

}
?>
